/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.code;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import me.hammerle.snuviscript.code.InputProvider;
import me.hammerle.snuviscript.code.Script;
import me.hammerle.snuviscript.code.Syntax;
import me.hammerle.snuviscript.exceptions.PreScriptException;

public class SnuviUtils {
    private static final Random RANDOM = new Random();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[-]{0,1}[0-9]*[.]{0,1}[0-9]*");
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("^[a-zA-Z.]*\\(.*\\)");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*\\[[^\\]]*\\]");

    public static int randomInt(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static boolean isNumber(String s) {
        return NUMBER_PATTERN.matcher(s).matches();
    }

    public static boolean isFunction(String s) {
        return FUNCTION_PATTERN.matcher(s).matches();
    }

    public static boolean isArray(String s) {
        return ARRAY_PATTERN.matcher(s).matches();
    }

    public static String toString(double d) {
        if (d == (double)((int)d)) {
            return String.valueOf((int)d);
        }
        return String.valueOf(d);
    }

    private static void addNonEmptyString(HashMap<String, String> strings, LinkedList<String> list, String s) {
        if (!(s = s.trim()).isEmpty()) {
            String text;
            if (s.startsWith("#") && (text = strings.get(s)) != null) {
                list.add(text);
                return;
            }
            list.add(s);
        }
    }

    private static int findNextClosingBracket(int pos, StringBuilder sb, int line) {
        int brackets = 0;
        int length = sb.length();
        while (pos < length) {
            switch (sb.charAt(pos)) {
                case ')': {
                    if (--brackets == 0) {
                        return pos;
                    }
                    if (brackets >= 0) break;
                    throw new PreScriptException(") without (", line);
                }
                case '(': {
                    ++brackets;
                }
            }
            ++pos;
        }
        throw new PreScriptException("( without )", line);
    }

    private static int findNextClosingSBracket(int pos, StringBuilder sb, int line) {
        int brackets = 0;
        int length = sb.length();
        while (pos < length) {
            switch (sb.charAt(pos)) {
                case ']': {
                    if (--brackets == 0) {
                        return pos;
                    }
                    if (brackets >= 0) break;
                    throw new PreScriptException("] without [", line);
                }
                case '[': {
                    ++brackets;
                }
            }
            ++pos;
        }
        throw new PreScriptException("[ without ]", line);
    }

    public static String[] split(HashMap<String, String> strings, String s, int line) {
        LinkedList<String> list = new LinkedList<String>();
        int old = 0;
        int pos = 0;
        StringBuilder sb = new StringBuilder(s);
        int length = sb.length();
        block9: while (pos < length) {
            char c = sb.charAt(pos);
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    case '#': 
                    case '$': 
                    case '.': 
                    case '@': 
                    case '_': {
                        break;
                    }
                    case ')': {
                        throw new PreScriptException(") without (", line);
                    }
                    case '(': {
                        pos = SnuviUtils.findNextClosingBracket(pos, sb, line) + 1;
                        SnuviUtils.addNonEmptyString(strings, list, sb.substring(old, pos));
                        old = pos;
                        continue block9;
                    }
                    case ']': {
                        throw new PreScriptException("] without [", line);
                    }
                    case '[': {
                        pos = SnuviUtils.findNextClosingSBracket(pos, sb, line) + 1;
                        SnuviUtils.addNonEmptyString(strings, list, sb.substring(old, pos));
                        old = pos;
                        continue block9;
                    }
                    case '\t': 
                    case ' ': {
                        SnuviUtils.addNonEmptyString(strings, list, sb.substring(old, pos));
                        pos = old = pos + 1;
                        continue block9;
                    }
                    case ',': {
                        SnuviUtils.addNonEmptyString(strings, list, sb.substring(old, pos));
                        SnuviUtils.addNonEmptyString(strings, list, ",");
                        pos = old = pos + 1;
                        continue block9;
                    }
                    default: {
                        SnuviUtils.addNonEmptyString(strings, list, sb.substring(old, pos));
                        old = pos++;
                        while (pos <= length && Syntax.getSyntax(sb.substring(old, pos)) != Syntax.UNKNOWN) {
                            ++pos;
                        }
                        if (old == --pos) {
                            throw new PreScriptException("unknown syntax '" + c + "'", line);
                        }
                        SnuviUtils.addNonEmptyString(strings, list, sb.substring(old, pos));
                        old = pos;
                        continue block9;
                    }
                }
            }
            ++pos;
        }
        if (old < length) {
            SnuviUtils.addNonEmptyString(strings, list, sb.substring(old));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getArrayString(Object array) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(array) - 1;
        for (int i = 0; i < length; ++i) {
            sb.append(Array.get(array, i));
            sb.append(", ");
        }
        if (length > 0) {
            sb.append(Array.get(array, length));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String connect(Script sc, InputProvider[] c, int skip) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = skip; i < c.length; ++i) {
            sb.append(c[i].getString(sc));
        }
        return sb.toString();
    }

    public static String connect(Script sc, InputProvider[] c, String s, int skip) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (skip < c.length) {
            sb.append(c[skip].getString(sc));
        }
        for (int i = skip + 1; i < c.length; ++i) {
            sb.append(s);
            sb.append(c[i].getString(sc));
        }
        return sb.toString();
    }

    public static List<String> readCode(String ending, String ... filenames) {
        LinkedList<List<String>> lists = new LinkedList<List<String>>();
        int lines = 0;
        for (String filename : filenames) {
            File script = new File("./" + filename + ending);
            if (script.exists()) {
                try {
                    List<String> list = Files.readAllLines(script.toPath());
                    lines += list.size();
                    lists.add(list);
                    continue;
                }
                catch (MalformedInputException ex) {
                    throw new PreScriptException("'" + script.getPath() + "' contains an illegal character, change file encoding", 0);
                }
                catch (IOException ex) {
                    throw new PreScriptException("file '" + script.getPath() + "' cannot be read", 0);
                }
            }
            throw new PreScriptException("file '" + script.getPath() + "' does not exist", 0);
        }
        ArrayList<String> mergedList = new ArrayList<String>(lines);
        lists.forEach(l -> mergedList.addAll((Collection<String>)l));
        return mergedList;
    }

    public static List<String> readCode(String filename) {
        return SnuviUtils.readCode(filename, ".snuvi");
    }
}

