/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.util;

import java.io.IOException;
import java.io.OutputStream;

public class WrappedOutputStream {
    private final OutputStream out;

    public WrappedOutputStream(OutputStream out) {
        this.out = out;
    }

    public void writeByte(int b) throws IOException {
        this.out.write(b);
    }

    public void writeUnsignedByte(int b) throws IOException {
        this.out.write(b);
    }

    public void writeShort(int s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >> 8 & 0xFF);
    }

    public void writeInt(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >> 8 & 0xFF);
        this.out.write(i >> 16 & 0xFF);
        this.out.write(i >> 24 & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.out.write((int)(l & 0xFFL));
        this.out.write((int)(l >> 8 & 0xFFL));
        this.out.write((int)(l >> 16 & 0xFFL));
        this.out.write((int)(l >> 24 & 0xFFL));
        this.out.write((int)(l >> 32 & 0xFFL));
        this.out.write((int)(l >> 40 & 0xFFL));
        this.out.write((int)(l >> 48 & 0xFFL));
        this.out.write((int)(l >> 56 & 0xFFL));
    }

    public void writeString(String s) throws IOException {
        byte[] b = s.getBytes();
        this.writeInt(b.length);
        this.out.write(b);
    }
}

