/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.io.IOException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import me.hammerle.snuviengine.api.ColorRenderer;
import me.hammerle.snuviengine.api.DirectTextureRenderer;
import me.hammerle.snuviengine.api.FontRenderer;
import me.hammerle.snuviengine.api.MatrixStack;
import me.hammerle.snuviengine.api.ShaderException;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL20;

public final class Shader {
    private static int program = -1;
    public static final int BASE_WIDTH = 1024;
    public static final int BASE_HEIGHT = 620;
    private static int width = 512;
    private static int height = 310;
    private static int scale = 2;
    private static final List<Runnable> TASKS = new LinkedList<Runnable>();
    protected static boolean initDone = false;
    private static final FontRenderer FONT_RENDERER = new FontRenderer();
    private static final ColorRenderer COLOR_RENDERER = new ColorRenderer();
    private static final DirectTextureRenderer TEXTURE_RENDERER = new DirectTextureRenderer();
    private static int unifViewMatrix = -1;
    private static int unifModelMatrix = -1;
    private static MatrixStack modelMatrix;
    private static int unifAmbientLight;
    private static int[][] unifLight;
    private static int unifUseTexture;
    private static int unifUseColor;
    private static int unifUseLight;
    private static int unifUseMixColor;
    private static int unifMixColorLoc;
    private static float[] unifMixColor;

    protected static void init() {
        program = Shader.createShaderProgram("vertex.vs", "fragment.fs");
        GL20.glUseProgram((int)program);
        unifViewMatrix = GL20.glGetUniformLocation((int)program, (CharSequence)"viewMatrix");
        Shader.updateViewMatrix();
        unifModelMatrix = GL20.glGetUniformLocation((int)program, (CharSequence)"modelMatrix");
        modelMatrix = new MatrixStack(20);
        Shader.updateMatrix();
        unifAmbientLight = GL20.glGetUniformLocation((int)program, (CharSequence)"ambientLight");
        Shader.setAmbientLight(1.0f, 1.0f, 1.0f);
        unifLight = new int[32][3];
        for (int index = 0; index < unifLight.length; ++index) {
            Shader.unifLight[index][0] = GL20.glGetUniformLocation((int)program, (CharSequence)("lights[" + index + "].color"));
            Shader.unifLight[index][1] = GL20.glGetUniformLocation((int)program, (CharSequence)("lights[" + index + "].pos"));
            Shader.unifLight[index][2] = GL20.glGetUniformLocation((int)program, (CharSequence)("lights[" + index + "].strength"));
            Shader.setLightColor(index, 0.0f, 0.0f, 0.0f);
            Shader.setLightLocation(index, 0.0f, 0.0f);
            Shader.setLightStrength(index, 0.0f);
        }
        unifUseTexture = GL20.glGetUniformLocation((int)program, (CharSequence)"useTexture");
        Shader.setTextureEnabled(false);
        unifUseColor = GL20.glGetUniformLocation((int)program, (CharSequence)"useColor");
        Shader.setColorEnabled(false);
        unifUseLight = GL20.glGetUniformLocation((int)program, (CharSequence)"useLight");
        Shader.setLightEnabled(false);
        unifUseMixColor = GL20.glGetUniformLocation((int)program, (CharSequence)"useMixColor");
        Shader.setMixColorEnabled(false);
        unifMixColorLoc = GL20.glGetUniformLocation((int)program, (CharSequence)"mixColor");
        Shader.setMixColor(0.0f, 0.0f, 0.0f, 0.0f);
        Shader.setViewPort(1024, 620);
        initDone = true;
    }

    protected static int getProgram() {
        return program;
    }

    protected static void addTask(Runnable r) {
        TASKS.add(r);
    }

    protected static void doTasks() {
        if (!TASKS.isEmpty()) {
            TASKS.forEach(r -> r.run());
            TASKS.clear();
        }
    }

    public static FontRenderer getFontRenderer() {
        return FONT_RENDERER;
    }

    public static ColorRenderer getColorRenderer() {
        return COLOR_RENDERER;
    }

    public static DirectTextureRenderer getTextureRenderer() {
        return TEXTURE_RENDERER;
    }

    private static void updateViewMatrix() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        buffer.put(2.0f / (float)width);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(-2.0f / (float)height);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(-1.0f / (float)height);
        buffer.put(0.0f);
        buffer.put(-1.0f);
        buffer.put(1.0f);
        buffer.put(0.5f);
        buffer.put(1.0f);
        buffer.flip();
        GL20.glUniformMatrix4fv((int)unifViewMatrix, (boolean)false, (FloatBuffer)buffer);
    }

    protected static void setViewPort(int width, int height) {
        scale = 1;
        while (width / (scale + 1) >= 400 && height / (scale + 1) >= 300) {
            ++scale;
        }
        Shader.width = width / scale;
        Shader.height = height / scale;
        Shader.updateViewMatrix();
    }

    public static int getViewScale() {
        return scale;
    }

    public static int getViewWidth() {
        return width;
    }

    public static int getViewHeight() {
        return height;
    }

    public static void updateMatrix() {
        GL20.glUniformMatrix4fv((int)unifModelMatrix, (boolean)false, (float[])modelMatrix.getData());
    }

    public static void pushMatrix() {
        modelMatrix.push();
    }

    public static void popMatrix() {
        modelMatrix.pop();
    }

    public static void translate(float tx, float ty) {
        modelMatrix.translate(tx, ty);
    }

    public static void translateTo(float tx, float ty) {
        modelMatrix.translateTo(tx, ty);
    }

    public static void scale(float sx, float sy) {
        modelMatrix.scale(sx, sy);
    }

    public static void rotate(float angle) {
        modelMatrix.rotate(angle);
    }

    public static void setAmbientLight(float r, float g, float b) {
        GL20.glUniform3f((int)unifAmbientLight, (float)r, (float)g, (float)b);
    }

    private static void checkLightIndex(int index) {
        if (index < 0 || index > unifLight.length) {
            throw new ShaderException("'" + index + "' is not a valid light index");
        }
    }

    public static void setLightColor(int index, float r, float g, float b) {
        Shader.checkLightIndex(index);
        GL20.glUniform3f((int)unifLight[index][0], (float)r, (float)g, (float)b);
    }

    public static void setLightLocation(int index, float x, float y) {
        Shader.checkLightIndex(index);
        GL20.glUniform2f((int)unifLight[index][1], (float)x, (float)y);
    }

    public static void setLightStrength(int index, float strength) {
        Shader.checkLightIndex(index);
        GL20.glUniform1f((int)unifLight[index][2], (float)strength);
    }

    public static void setTextureEnabled(boolean use) {
        GL20.glUniform1i((int)unifUseTexture, (int)(use ? 1 : 0));
    }

    public static void setColorEnabled(boolean use) {
        GL20.glUniform1i((int)unifUseColor, (int)(use ? 1 : 0));
    }

    public static void setMixColorEnabled(boolean use) {
        GL20.glUniform1i((int)unifUseMixColor, (int)(use ? 1 : 0));
    }

    public static void setMixColor(float r, float g, float b, float a) {
        Shader.unifMixColor[0] = r;
        Shader.unifMixColor[1] = g;
        Shader.unifMixColor[2] = b;
        Shader.unifMixColor[3] = a;
        GL20.glUniform4fv((int)unifMixColorLoc, (float[])unifMixColor);
    }

    public static void setLightEnabled(boolean use) {
        GL20.glUniform1i((int)unifUseLight, (int)(use ? 1 : 0));
    }

    public static void setDepthTestEnabled(boolean use) {
        if (use) {
            GL11.glEnable((int)2929);
            GL11.glDepthFunc((int)515);
        } else {
            GL11.glDisable((int)2929);
        }
    }

    public static void setBlendingEnabled(boolean use) {
        if (use) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL14.glBlendEquation((int)32774);
        } else {
            GL11.glDisable((int)3042);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] readFile(String name) {
        URL url = Shader.class.getClassLoader().getResource("me/hammerle/snuviengine/shader/" + name);
        if (url == null) {
            throw new ShaderException("failed reading shader '" + name + "'");
        }
        ArrayList<String> strings = new ArrayList<String>();
        try (Scanner scanner = new Scanner(url.openStream());){
            while (scanner.hasNext()) {
                strings.add(scanner.nextLine() + "\n");
            }
            String[] stringArray = strings.toArray(new String[strings.size()]);
            return stringArray;
        }
        catch (IOException ex) {
            throw new ShaderException("failed reading shader '" + name + "'");
        }
    }

    private static String getError() {
        StringBuilder sb = new StringBuilder();
        int glErr = GL11.glGetError();
        while (glErr != 0) {
            sb.append(glErr);
            sb.append(" ");
            glErr = GL11.glGetError();
        }
        return sb.toString();
    }

    private static int createShaderProgram(String vertex, String fragment) {
        CharSequence[] vShaderSource = Shader.readFile(vertex);
        int vShader = GL20.glCreateShader((int)35633);
        GL20.glShaderSource((int)vShader, (CharSequence[])vShaderSource);
        GL20.glCompileShader((int)vShader);
        String error = Shader.getError();
        if (!error.isEmpty()) {
            throw new ShaderException("failed compiling vertex shader '" + vertex + "' " + error);
        }
        int compiled = GL20.glGetShaderi((int)vShader, (int)35713);
        if (compiled != 1) {
            throw new ShaderException("failed compiling vertex shader '" + vertex + "' " + compiled + " " + GL20.glGetShaderInfoLog((int)vShader));
        }
        CharSequence[] fShaderSource = Shader.readFile(fragment);
        int fShader = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)fShader, (CharSequence[])fShaderSource);
        GL20.glCompileShader((int)fShader);
        error = Shader.getError();
        if (!error.isEmpty()) {
            throw new ShaderException("failed compiling fragment shader '" + fragment + "' " + error);
        }
        compiled = GL20.glGetShaderi((int)fShader, (int)35713);
        if (compiled != 1) {
            throw new ShaderException("failed compiling fragment shader '" + fragment + "' " + compiled + " " + GL20.glGetShaderInfoLog((int)fShader));
        }
        int vfprogram = GL20.glCreateProgram();
        GL20.glAttachShader((int)vfprogram, (int)vShader);
        GL20.glAttachShader((int)vfprogram, (int)fShader);
        GL20.glLinkProgram((int)vfprogram);
        error = Shader.getError();
        if (!error.isEmpty()) {
            throw new ShaderException("failed linking shaders '" + vertex + "' and '" + fragment + "' " + error);
        }
        compiled = GL20.glGetProgrami((int)vfprogram, (int)35714);
        if (compiled != 1) {
            throw new ShaderException("failed linking shaders '" + vertex + "' and '" + fragment + "' " + compiled + " " + GL20.glGetProgramInfoLog((int)vfprogram));
        }
        GL20.glDeleteShader((int)vShader);
        GL20.glDeleteShader((int)fShader);
        return vfprogram;
    }

    static {
        unifAmbientLight = -1;
        unifUseTexture = -1;
        unifUseColor = -1;
        unifUseLight = -1;
        unifUseMixColor = -1;
        unifMixColorLoc = -1;
        unifMixColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }
}

