/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.util.HashMap;
import me.hammerle.snuviengine.api.KeyBinding;
import me.hammerle.snuviengine.api.KeyDuplicateException;

public final class KeyHandler {
    private static final HashMap<Integer, KeyBinding> BINDINGS = new HashMap();
    private static KeyBinding rebind = null;

    public static KeyBinding register(int key) throws KeyDuplicateException {
        KeyBinding binding = new KeyBinding(key);
        if (BINDINGS.putIfAbsent(key, binding) != null) {
            throw new KeyDuplicateException("the key '" + key + "' has already been registered");
        }
        return binding;
    }

    public static void rebind(KeyBinding binding) {
        rebind = binding;
        if (binding != null) {
            binding.setIsRebinding(true);
        }
    }

    public static void rebind(KeyBinding binding, int key) {
        if (BINDINGS.containsKey(key)) {
            return;
        }
        BINDINGS.remove(binding.getKey());
        binding.setKey(key);
        BINDINGS.put(key, binding);
    }

    protected static void onKeyDownEvent(int key) {
        if (rebind != null) {
            rebind.setIsRebinding(false);
            KeyHandler.rebind(rebind, key);
            rebind = null;
            return;
        }
        KeyBinding binding = BINDINGS.get(key);
        if (binding != null) {
            binding.onKeyDownEvent();
        }
    }

    protected static void onKeyUpEvent(int key) {
        KeyBinding binding = BINDINGS.get(key);
        if (binding != null) {
            binding.onKeyUpEvent();
        }
    }

    protected static void tick() {
        BINDINGS.values().forEach(binding -> binding.tick());
    }
}

