/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.nio.ByteBuffer;
import me.hammerle.snuviengine.api.GLHelper;
import me.hammerle.snuviengine.api.Shader;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ColorRenderer {
    private int vao;
    private int vbo;
    private ByteBuffer buffer = BufferUtils.createByteBuffer((int)64);
    private static final int BUFFER_BYTE_LENGTH = 0x100000;
    private static final int OBJECT_LENGTH = 64;
    private int offset = 1048512;
    private float depth = 0.0f;

    protected ColorRenderer() {
        Shader.addTask(() -> {
            this.vao = GL30.glGenVertexArrays();
            this.vbo = GL15.glGenBuffers();
            GLHelper.glBindVertexArray(this.vao);
            GLHelper.glBindBuffer(this.vbo);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)2);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)16, (long)0L);
            GL20.glVertexAttribPointer((int)2, (int)4, (int)5121, (boolean)true, (int)16, (long)12L);
        });
    }

    public void setDepth(float depth) {
        this.depth = depth;
    }

    public void drawRectangle(float minX, float minY, float maxX, float maxY, int color) {
        GLHelper.glBindBuffer(this.vbo);
        this.offset += 64;
        if (this.offset + 64 >= 0x100000) {
            this.offset = 0;
            GL15.glBufferData((int)34962, (long)0x100000L, (int)35040);
        }
        this.buffer = GL30.glMapBufferRange((int)34962, (long)this.offset, (long)64L, (int)34, (ByteBuffer)this.buffer);
        if (this.buffer == null) {
            return;
        }
        float fcolor = Float.intBitsToFloat(color);
        this.buffer.putFloat(minX);
        this.buffer.putFloat(maxY);
        this.buffer.putFloat(this.depth);
        this.buffer.putFloat(fcolor);
        this.buffer.putFloat(minX);
        this.buffer.putFloat(minY);
        this.buffer.putFloat(this.depth);
        this.buffer.putFloat(fcolor);
        this.buffer.putFloat(maxX);
        this.buffer.putFloat(maxY);
        this.buffer.putFloat(this.depth);
        this.buffer.putFloat(fcolor);
        this.buffer.putFloat(maxX);
        this.buffer.putFloat(minY);
        this.buffer.putFloat(this.depth);
        this.buffer.putFloat(fcolor);
        this.buffer.flip();
        GL15.glUnmapBuffer((int)34962);
        GLHelper.glBindVertexArray(this.vao);
        GL11.glDrawArrays((int)5, (int)(this.offset / 16), (int)4);
    }
}

