/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBVertexArrayObject {
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;

    protected ARBVertexArrayObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBindVertexArray, caps.glDeleteVertexArrays, caps.glGenVertexArrays, caps.glIsVertexArray});
    }

    public static native void glBindVertexArray(@NativeType(value="GLuint") int var0);

    public static native void nglDeleteVertexArrays(int var0, long var1);

    public static void glDeleteVertexArrays(@NativeType(value="const GLuint *") IntBuffer arrays) {
        ARBVertexArrayObject.nglDeleteVertexArrays(arrays.remaining(), MemoryUtil.memAddress((IntBuffer)arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteVertexArrays(@NativeType(value="const GLuint *") int array) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.ints(array);
            ARBVertexArrayObject.nglDeleteVertexArrays(1, MemoryUtil.memAddress((IntBuffer)arrays));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenVertexArrays(int var0, long var1);

    public static void glGenVertexArrays(@NativeType(value="GLuint *") IntBuffer arrays) {
        ARBVertexArrayObject.nglGenVertexArrays(arrays.remaining(), MemoryUtil.memAddress((IntBuffer)arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenVertexArrays() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.callocInt(1);
            ARBVertexArrayObject.nglGenVertexArrays(1, MemoryUtil.memAddress((IntBuffer)arrays));
            int n = arrays.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLboolean")
    public static native boolean glIsVertexArray(@NativeType(value="GLuint") int var0);

    public static void glDeleteVertexArrays(@NativeType(value="const GLuint *") int[] arrays) {
        long __functionAddress = GL.getICD().glDeleteVertexArrays;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)arrays.length, (int[])arrays);
    }

    public static void glGenVertexArrays(@NativeType(value="GLuint *") int[] arrays) {
        long __functionAddress = GL.getICD().glGenVertexArrays;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)arrays.length, (int[])arrays);
    }

    static {
        GL.initialize();
    }
}

