/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.config;

import java.io.File;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.TreeMap;
import java.util.stream.Collectors;
import me.hammerle.snuviscript.code.Compiler;
import me.hammerle.snuviscript.code.ISnuviLogger;
import me.hammerle.snuviscript.code.Script;

public class SnuviConfig {
    protected final ISnuviLogger logger;
    protected final TreeMap<String, Object> conf;
    private final File file;
    private Script sc;

    private SnuviConfig(Script sc, ISnuviLogger logger, String path, String name) {
        this.sc = sc;
        this.logger = logger;
        StringBuilder sb = new StringBuilder("./");
        sb.append(path);
        sb.append("/");
        sb.append(name);
        sb.append(".snuvic");
        this.file = new File(sb.toString());
        this.conf = new TreeMap();
    }

    public SnuviConfig(ISnuviLogger logger, String path, String name) {
        this(null, logger, path, name);
    }

    public SnuviConfig(Script sc, String path, String name) {
        this(sc, sc.getLogger(), path, name);
    }

    private void print(String message, Exception ex) {
        this.logger.print(message, ex, null, this.sc == null ? null : this.sc.getName(), this.sc, this.sc == null ? -1 : this.sc.getActiveRealLine());
    }

    private void print(String message) {
        this.print(message, null);
    }

    public final void load() {
        if (!this.exists()) {
            this.print("cannot load non existent file '" + this.file.getPath() + "'");
            return;
        }
        try {
            String warning = "wrong syntax in '" + this.file.getPath() + "'";
            Files.readAllLines(this.file.toPath()).stream().forEach(s -> {
                int b = s.indexOf("=");
                if (b == -1) {
                    this.print(warning);
                    this.print((String)s);
                } else {
                    this.conf.put(s.substring(0, b).trim(), Compiler.convert(s.substring(b + 1)));
                }
            });
        }
        catch (MalformedInputException ex) {
            this.print("'" + this.file.getPath() + "' contains an illegal character, change file encoding", ex);
        }
        catch (OutOfMemoryError ex) {
            this.print("'" + this.file.getPath() + "' is too big");
        }
        catch (SecurityException ex) {
            this.print("'" + this.file.getPath() + "' is not accessable", ex);
        }
        catch (IOException ex) {
            this.print("'" + this.file.getPath() + "' cannot be read", ex);
        }
    }

    public final boolean exists() {
        return this.file.exists();
    }

    public final boolean delete() {
        return this.file.delete();
    }

    public final boolean save() {
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException ex) {
                    this.print("'" + this.file.getPath() + "' cannot be created", ex);
                    return false;
                }
            }
            Files.write(Paths.get(this.file.toURI()), (Iterable<? extends CharSequence>)this.conf.entrySet().stream().map(e -> {
                if (e.getValue().getClass() == String.class) {
                    return (String)e.getKey() + "=\"" + e.getValue() + "\"";
                }
                return (String)e.getKey() + "=" + String.valueOf(e.getValue());
            }).collect(Collectors.toList()), StandardCharsets.UTF_8, new OpenOption[0]);
            return true;
        }
        catch (UnsupportedOperationException ex) {
            this.print("an unsupported operation was used", ex);
            return false;
        }
        catch (SecurityException ex) {
            this.print("'" + this.file.getPath() + "' is not accessable", ex);
            return false;
        }
        catch (IOException ex) {
            this.print("cannot write to '" + this.file.getPath() + "'", ex);
            return false;
        }
    }

    public final <T> T get(String key, Class<T> c, T error) {
        try {
            Object o = this.conf.get(key);
            if (o == null) {
                return error;
            }
            return c.cast(o);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            return error;
        }
    }

    public final String getString(String key, String error) {
        return this.get(key, String.class, error);
    }

    public final String getString(String key) {
        return this.getString(key, null);
    }

    public final float getFloat(String key, float error) {
        return this.get(key, Double.class, Double.valueOf(error)).floatValue();
    }

    public final double getDouble(String key, double error) {
        return this.get(key, Double.class, error);
    }

    public final int getInt(String key, int error) {
        return this.get(key, Double.class, Double.valueOf(error)).intValue();
    }

    public final boolean getBoolean(String key, boolean error) {
        return this.get(key, Boolean.class, error);
    }

    public final void set(String key, Object o) {
        this.conf.put(key, o);
    }
}

