/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.code;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.hammerle.snuviscript.array.DynamicArray;
import me.hammerle.snuviscript.code.BasicFunction;
import me.hammerle.snuviscript.code.Compiler;
import me.hammerle.snuviscript.code.ExceptionBiFunction;
import me.hammerle.snuviscript.code.InputProvider;
import me.hammerle.snuviscript.code.Script;
import me.hammerle.snuviscript.code.SnuviUtils;
import me.hammerle.snuviscript.config.SnuviConfig;
import me.hammerle.snuviscript.variable.ArrayVariable;
import me.hammerle.snuviscript.variable.Variable;

public class FunctionLoader {
    private static final HashMap<String, BasicFunction> FUNCTIONS = new HashMap();

    protected static void registerFunction(String name, String fname, ExceptionBiFunction<Script, InputProvider[], Object> f) {
        FUNCTIONS.put(name, new BasicFunction(fname, f));
    }

    protected static void registerFunction(String name, ExceptionBiFunction<Script, InputProvider[], Object> f) {
        FunctionLoader.registerFunction(name, name, f);
    }

    protected static void registerAlias(String original, String alias) {
        FUNCTIONS.put(alias, FUNCTIONS.get(original));
    }

    public static BasicFunction getFunction(String f) {
        String function = f.toLowerCase();
        return FUNCTIONS.getOrDefault(function, new BasicFunction(function, (sc, in) -> {
            Integer sub = sc.functions.get(function);
            if (sub == null) {
                throw new NullPointerException("function " + function + " does not exist");
            }
            InputProvider[] arguments = sc.code[sub].getArguments();
            HashMap<String, Variable> vars = new HashMap<String, Variable>();
            if (((InputProvider[])in).length != arguments.length - 1) {
                throw new NullPointerException("invalid number of arguments at function '" + function + "'");
            }
            for (int i = 0; i < ((InputProvider[])in).length; ++i) {
                Variable v;
                String s = arguments[i + 1].getString((Script)sc);
                if (in[i].isArray((Script)sc)) {
                    v = new ArrayVariable(s);
                    v.set((Script)sc, in[i].getArray((Script)sc));
                } else {
                    v = new Variable(s);
                    v.set((Script)sc, in[i].get((Script)sc));
                }
                vars.put(s, v);
            }
            sc.currentFunction = function;
            sc.localVars.push(vars);
            sc.returnStack.push(sc.currentLine);
            sc.currentLine = sub + 1;
            Object r = sc.run();
            sc.currentLine = sc.returnStack.pop();
            sc.localVars.pop();
            sc.currentFunction = null;
            return r;
        }));
    }

    static {
        FunctionLoader.registerFunction("nothing", (sc, in) -> Void.TYPE);
        FunctionLoader.registerFunction("error", (sc, in) -> {
            sc.printStackTrace = !sc.printStackTrace;
            return sc.printStackTrace;
        });
        FunctionLoader.registerFunction("", (sc, in) -> in[0].get((Script)sc));
        FunctionLoader.registerFunction("event.load", (sc, in) -> {
            sc.events.add(in[0].getString((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("event.unload", (sc, in) -> {
            sc.events.remove(in[0].getString((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("event.isloaded", (sc, in) -> sc.isEventLoaded(in[0].getString((Script)sc)));
        FunctionLoader.registerFunction("script.get", (sc, in) -> {
            String name = in[0].getString((Script)sc);
            for (Script script : sc.parser.getScripts()) {
                if (!script.getName().equals(name)) continue;
                return script;
            }
            return null;
        });
        FunctionLoader.registerFunction("script.getall", (sc, in) -> {
            String name = in[0].getString((Script)sc);
            return sc.parser.getScripts().stream().filter(script -> script.getName().equals(name)).collect(Collectors.toList());
        });
        FunctionLoader.registerFunction("script.term", (sc, in) -> {
            sc.parser.termSafe((Script)in[0].get((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction(">>", (sc, in) -> (double)(in[0].getInt((Script)sc) >> in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("<<", (sc, in) -> (double)(in[0].getInt((Script)sc) << in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("&", (sc, in) -> (double)(in[0].getInt((Script)sc) & in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("|", (sc, in) -> (double)(in[0].getInt((Script)sc) | in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("^", (sc, in) -> (double)(in[0].getInt((Script)sc) ^ in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("~", (sc, in) -> (double)(~in[0].getInt((Script)sc)));
        FunctionLoader.registerFunction("bit.set", (sc, in) -> (double)(in[0].getInt((Script)sc) | 1 << in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("bit.unset", (sc, in) -> (double)(in[0].getInt((Script)sc) & ~(1 << in[1].getInt((Script)sc))));
        FunctionLoader.registerFunction("bit.get", (sc, in) -> (in[0].getInt((Script)sc) & 1 << in[1].getInt((Script)sc)) != 0);
        FunctionLoader.registerFunction("%", (sc, in) -> (double)(in[0].getInt((Script)sc) % in[1].getInt((Script)sc)));
        FunctionLoader.registerAlias("%", "math.mod");
        FunctionLoader.registerFunction("math.abs", (sc, in) -> Math.abs(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.pow", (sc, in) -> Math.pow(in[0].getDouble((Script)sc), in[1].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.root", (sc, in) -> Math.pow(in[0].getDouble((Script)sc), 1.0 / in[1].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.sqrt", (sc, in) -> Math.sqrt(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.hypot", (sc, in) -> Math.hypot(in[0].getDouble((Script)sc), in[1].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.sin", (sc, in) -> Math.sin(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.cos", (sc, in) -> Math.cos(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.tan", (sc, in) -> Math.tan(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.asin", (sc, in) -> Math.asin(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.acos", (sc, in) -> Math.acos(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.atan", (sc, in) -> Math.atan(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.e", (sc, in) -> Math.E);
        FunctionLoader.registerFunction("math.pi", (sc, in) -> Math.PI);
        FunctionLoader.registerFunction("math.ln", (sc, in) -> Math.log(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.log", (sc, in) -> Math.log10(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.random", (sc, in) -> (double)SnuviUtils.randomInt(in[0].getInt((Script)sc), in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("math.round", (sc, in) -> (double)Math.round(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.rounddown", (sc, in) -> Math.floor(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.roundup", (sc, in) -> Math.ceil(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("math.roundcomma", (sc, in) -> {
            double d = in[0].getDouble((Script)sc);
            int factor = (int)Math.pow(10.0, in[1].getInt((Script)sc));
            return (double)Math.round(d * (double)factor) / (double)factor;
        });
        FunctionLoader.registerFunction("list.new", (sc, in) -> {
            if (((InputProvider[])in).length == 0) {
                return new ArrayList();
            }
            in[0].set((Script)sc, new ArrayList());
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("list.exists", (sc, in) -> in[0].get((Script)sc) instanceof List);
        FunctionLoader.registerFunction("list.add", (sc, in) -> ((List)in[0].get((Script)sc)).add(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("list.addall", (sc, in) -> {
            List list = (List)in[0].get((Script)sc);
            for (int i = 1; i < ((InputProvider[])in).length; ++i) {
                list.add(in[i].get((Script)sc));
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("list.remove", (sc, in) -> ((List)in[0].get((Script)sc)).remove(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("list.removeindex", (sc, in) -> ((List)in[0].get((Script)sc)).remove(in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("list.contains", (sc, in) -> ((List)in[0].get((Script)sc)).contains(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("list.getsize", (sc, in) -> (double)((List)in[0].get((Script)sc)).size());
        FunctionLoader.registerFunction("list.getindex", (sc, in) -> ((List)in[0].get((Script)sc)).get(in[1].getInt((Script)sc)));
        FunctionLoader.registerAlias("list.getindex", "list.get");
        FunctionLoader.registerFunction("list.setindex", (sc, in) -> ((List)in[0].get((Script)sc)).set(in[1].getInt((Script)sc), in[2].get((Script)sc)));
        FunctionLoader.registerFunction("list.clear", (sc, in) -> {
            ((List)in[0].get((Script)sc)).clear();
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("list.getindexof", (sc, in) -> (double)((List)in[0].get((Script)sc)).indexOf(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("list.sort", (sc, in) -> {
            Collections.sort((List)in[0].get((Script)sc), (o1, o2) -> ((Comparable)o1).compareTo(o2));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("list.reverse", (sc, in) -> {
            Collections.reverse((List)in[0].get((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("list.shuffle", (sc, in) -> {
            Collections.shuffle((List)in[0].get((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("array.new", (sc, in) -> {
            for (InputProvider input : in) {
                ((DynamicArray)input).init((Script)sc);
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("array.getsize", (sc, in) -> (double)Array.getLength(in[0].getArray((Script)sc)));
        FunctionLoader.registerFunction("map.new", (sc, in) -> {
            if (((InputProvider[])in).length == 0) {
                return new HashMap();
            }
            in[0].set((Script)sc, new HashMap());
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("map.exists", (sc, in) -> in[0].get((Script)sc) instanceof Map);
        FunctionLoader.registerFunction("map.add", (sc, in) -> ((Map)in[0].get((Script)sc)).put(in[1].get((Script)sc), in[2].get((Script)sc)));
        FunctionLoader.registerFunction("map.remove", (sc, in) -> ((Map)in[0].get((Script)sc)).remove(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("map.contains", (sc, in) -> ((Map)in[0].get((Script)sc)).containsKey(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("map.getsize", (sc, in) -> (double)((Map)in[0].get((Script)sc)).size());
        FunctionLoader.registerFunction("map.get", (sc, in) -> ((Map)in[0].get((Script)sc)).get(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("map.getordefault", (sc, in) -> ((Map)in[0].get((Script)sc)).getOrDefault(in[1].get((Script)sc), in[2].get((Script)sc)));
        FunctionLoader.registerFunction("map.clear", (sc, in) -> {
            ((Map)in[0].get((Script)sc)).clear();
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("map.keys", (sc, in) -> ((Map)in[0].get((Script)sc)).keySet().stream().collect(Collectors.toList()));
        FunctionLoader.registerFunction("map.values", (sc, in) -> ((Map)in[0].get((Script)sc)).values().stream().collect(Collectors.toList()));
        FunctionLoader.registerFunction("set.new", (sc, in) -> {
            if (((InputProvider[])in).length == 0) {
                return new HashSet();
            }
            in[0].set((Script)sc, new HashSet());
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("set.exists", (sc, in) -> in[0].get((Script)sc) instanceof Set);
        FunctionLoader.registerFunction("set.add", (sc, in) -> ((Set)in[0].get((Script)sc)).add(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("set.addall", (sc, in) -> {
            Set set = (Set)in[0].get((Script)sc);
            for (int i = 1; i < ((InputProvider[])in).length; ++i) {
                set.add(in[i].get((Script)sc));
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("set.remove", (sc, in) -> ((Set)in[0].get((Script)sc)).remove(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("set.contains", (sc, in) -> ((Set)in[0].get((Script)sc)).contains(in[1].get((Script)sc)));
        FunctionLoader.registerFunction("set.getsize", (sc, in) -> (double)((Set)in[0].get((Script)sc)).size());
        FunctionLoader.registerFunction("set.tolist", (sc, in) -> ((Set)in[0].get((Script)sc)).stream().collect(Collectors.toList()));
        FunctionLoader.registerFunction("set.clear", (sc, in) -> {
            ((Set)in[0].get((Script)sc)).clear();
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("time.new", (sc, in) -> {
            if (((InputProvider[])in).length <= 1) {
                GregorianCalendar cal = GregorianCalendar.from(ZonedDateTime.now());
                cal.setTimeInMillis(in[0].getLong((Script)sc));
                return cal;
            }
            GregorianCalendar cal = GregorianCalendar.from(ZonedDateTime.now());
            cal.setTimeInMillis(in[1].getLong((Script)sc));
            in[0].set((Script)sc, cal);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("time.getmillis", (sc, in) -> (double)System.currentTimeMillis());
        FunctionLoader.registerFunction("time.getnanos", (sc, in) -> (double)System.nanoTime());
        FunctionLoader.registerFunction("time.from", (sc, in) -> (double)((GregorianCalendar)in[0].get((Script)sc)).getTimeInMillis());
        FunctionLoader.registerFunction("time.nextday", (sc, in) -> {
            GregorianCalendar cal = (GregorianCalendar)in[0].get((Script)sc);
            cal.add(6, 1);
            cal.set(11, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(14, 0);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("time.getyear", (sc, in) -> (double)((GregorianCalendar)in[0].get((Script)sc)).get(1));
        FunctionLoader.registerFunction("time.getmonth", (sc, in) -> (double)(((GregorianCalendar)in[0].get((Script)sc)).get(2) + 1));
        FunctionLoader.registerFunction("time.getday", (sc, in) -> (double)((GregorianCalendar)in[0].get((Script)sc)).get(5));
        FunctionLoader.registerFunction("time.gethour", (sc, in) -> (double)((GregorianCalendar)in[0].get((Script)sc)).get(11));
        FunctionLoader.registerFunction("time.getminute", (sc, in) -> (double)((GregorianCalendar)in[0].get((Script)sc)).get(12));
        FunctionLoader.registerFunction("time.getsecond", (sc, in) -> (double)((GregorianCalendar)in[0].get((Script)sc)).get(13));
        FunctionLoader.registerFunction("text.matches", (sc, in) -> in[0].getString((Script)sc).matches(in[1].getString((Script)sc)));
        FunctionLoader.registerFunction("text.number", (sc, in) -> SnuviUtils.toString(in[0].getDouble((Script)sc)));
        FunctionLoader.registerFunction("text.class", (sc, in) -> in[0].get((Script)sc).getClass().getSimpleName());
        FunctionLoader.registerFunction("text.tolowercase", (sc, in) -> SnuviUtils.connect(sc, in, 0).toLowerCase());
        FunctionLoader.registerAlias("text.tolowercase", "tolowercase");
        FunctionLoader.registerFunction("text.touppercase", (sc, in) -> SnuviUtils.connect(sc, in, 0).toUpperCase());
        FunctionLoader.registerAlias("text.touppercase", "touppercase");
        FunctionLoader.registerFunction("text.split", (sc, in) -> {
            if (((InputProvider[])in).length <= 2) {
                String[] parts = in[1].getString((Script)sc).split(in[0].getString((Script)sc));
                ArrayList<Object> list = new ArrayList<Object>();
                for (String part : parts) {
                    list.add(Compiler.convert(part));
                }
                return list;
            }
            String[] parts = in[2].getString((Script)sc).split(in[1].getString((Script)sc));
            ArrayList<Object> list = new ArrayList<Object>();
            for (String part : parts) {
                list.add(Compiler.convert(part));
            }
            in[0].set((Script)sc, list);
            return Void.TYPE;
        });
        FunctionLoader.registerAlias("text.split", "split");
        FunctionLoader.registerFunction("text.concatlist", (sc, in) -> {
            int from;
            StringBuilder sb = new StringBuilder();
            List list = (List)in[0].get((Script)sc);
            String splitter = in[1].getString((Script)sc);
            Iterator iter = list.iterator();
            int to = Math.min(in[3].getInt((Script)sc), list.size() - 1);
            to -= from;
            for (from = in[2].getInt((Script)sc); iter.hasNext() && from > 0; --from) {
                iter.next();
            }
            while (iter.hasNext() && to > 0) {
                sb.append(iter.next());
                sb.append(splitter);
                --to;
            }
            if (iter.hasNext() && to == 0) {
                sb.append(iter.next());
            }
            return sb.toString();
        });
        FunctionLoader.registerAlias("text.concatlist", "concatlist");
        FunctionLoader.registerFunction("text.concat", (sc, in) -> SnuviUtils.connect(sc, in, 0));
        FunctionLoader.registerAlias("text.concat", "concat");
        FunctionLoader.registerFunction("text.concatspace", (sc, in) -> SnuviUtils.connect(sc, in, " ", 0));
        FunctionLoader.registerFunction("text", (sc, in) -> String.valueOf(in[0].get((Script)sc)));
        FunctionLoader.registerFunction("text.substring", (sc, in) -> in[0].getString((Script)sc).substring(in[1].getInt((Script)sc), in[2].getInt((Script)sc)));
        FunctionLoader.registerFunction("text.length", (sc, in) -> (double)in[0].getString((Script)sc).length());
        FunctionLoader.registerFunction("text.startswith", (sc, in) -> in[0].getString((Script)sc).startsWith(in[1].getString((Script)sc), in[2].getInt((Script)sc)));
        FunctionLoader.registerFunction("text.endswith", (sc, in) -> in[0].getString((Script)sc).endsWith(in[1].getString((Script)sc)));
        FunctionLoader.registerFunction("text.contains", (sc, in) -> in[0].getString((Script)sc).contains(in[1].getString((Script)sc)));
        FunctionLoader.registerFunction("text.indexof", (sc, in) -> in[0].getString((Script)sc).indexOf(in[1].getString((Script)sc), in[2].getInt((Script)sc)));
        FunctionLoader.registerFunction("text.lastindexof", (sc, in) -> in[0].getString((Script)sc).lastIndexOf(in[1].getString((Script)sc), in[2].getInt((Script)sc)));
        FunctionLoader.registerFunction("text.replace", (sc, in) -> in[0].getString((Script)sc).replace(in[1].getString((Script)sc), in[2].getString((Script)sc)));
        FunctionLoader.registerFunction("text.trim", (sc, in) -> in[0].getString((Script)sc).trim());
        FunctionLoader.registerFunction("text.charat", (sc, in) -> String.valueOf(in[0].getString((Script)sc).charAt(in[1].getInt((Script)sc))));
        FunctionLoader.registerFunction("text.charcode", (sc, in) -> (double)in[0].getString((Script)sc).charAt(in[1].getInt((Script)sc)));
        FunctionLoader.registerFunction("text.fromcode", (sc, in) -> String.valueOf((char)in[0].getInt((Script)sc)));
        FunctionLoader.registerFunction("text.onlyletters", (sc, in) -> {
            for (char c : in[0].getString((Script)sc).toCharArray()) {
                if (Character.isLetter(c)) continue;
                return false;
            }
            return true;
        });
        FunctionLoader.registerFunction("file.new", (sc, in) -> new File(in[0].getString((Script)sc)));
        FunctionLoader.registerFunction("file.exists", (sc, in) -> ((File)in[0].get((Script)sc)).exists());
        FunctionLoader.registerFunction("file.isfile", (sc, in) -> ((File)in[0].get((Script)sc)).isFile());
        FunctionLoader.registerFunction("file.isdirectory", (sc, in) -> ((File)in[0].get((Script)sc)).isDirectory());
        FunctionLoader.registerFunction("file.delete", (sc, in) -> ((File)in[0].get((Script)sc)).delete());
        FunctionLoader.registerFunction("file.getname", (sc, in) -> ((File)in[0].get((Script)sc)).getName());
        FunctionLoader.registerFunction("file.getlist", (sc, in) -> Arrays.asList(((File)in[0].get((Script)sc)).listFiles()));
        FunctionLoader.registerFunction("file.read", (sc, in) -> Files.readAllLines(((File)in[0].get((Script)sc)).toPath()));
        FunctionLoader.registerFunction("file.write", (sc, in) -> {
            File f = (File)in[0].get((Script)sc);
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            Files.write(Paths.get(f.toURI()), (Iterable<? extends CharSequence>)((List)in[1].get((Script)sc)).stream().map(o -> String.valueOf(o)).collect(Collectors.toList()), StandardCharsets.UTF_8, new OpenOption[0]);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("config.new", (sc, in) -> new SnuviConfig((Script)sc, in[0].getString((Script)sc), in[1].getString((Script)sc)));
        FunctionLoader.registerFunction("config.exists", (sc, in) -> ((SnuviConfig)in[0].get((Script)sc)).exists());
        FunctionLoader.registerFunction("config.save", (sc, in) -> ((SnuviConfig)in[0].get((Script)sc)).save());
        FunctionLoader.registerFunction("config.load", (sc, in) -> {
            ((SnuviConfig)in[0].get((Script)sc)).load();
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("config.delete", (sc, in) -> ((SnuviConfig)in[0].get((Script)sc)).delete());
        FunctionLoader.registerFunction("config.set", (sc, in) -> {
            ((SnuviConfig)in[0].get((Script)sc)).set(in[1].getString((Script)sc), in[2].get((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("config.getbool", (sc, in) -> ((SnuviConfig)in[0].get((Script)sc)).getBoolean(in[1].getString((Script)sc), in[2].getBoolean((Script)sc)));
        FunctionLoader.registerFunction("config.getdouble", (sc, in) -> ((SnuviConfig)in[0].get((Script)sc)).getDouble(in[1].getString((Script)sc), in[2].getDouble((Script)sc)));
        FunctionLoader.registerFunction("config.getstring", (sc, in) -> ((SnuviConfig)in[0].get((Script)sc)).getString(in[1].getString((Script)sc), in[2].getString((Script)sc)));
        FunctionLoader.registerFunction("read.number", (sc, in) -> Double.parseDouble(in[0].getString((Script)sc)));
        FunctionLoader.registerFunction("+", (sc, in) -> in[0].getDouble((Script)sc) + in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias("+", "add");
        FunctionLoader.registerFunction("-", (sc, in) -> in[0].getDouble((Script)sc) - in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias("-", "sub");
        FunctionLoader.registerFunction("*", (sc, in) -> in[0].getDouble((Script)sc) * in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias("*", "mul");
        FunctionLoader.registerFunction("/", (sc, in) -> in[0].getDouble((Script)sc) / in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias("/", "div");
        FunctionLoader.registerFunction("=", (sc, in) -> {
            Object o = in[1].get((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("+=", (sc, in) -> {
            Double o = in[0].getDouble((Script)sc) + in[1].getDouble((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("p++", (sc, in) -> {
            double d = in[0].getDouble((Script)sc);
            in[0].set((Script)sc, d + 1.0);
            return d;
        });
        FunctionLoader.registerAlias("p++", "inc");
        FunctionLoader.registerFunction("++", (sc, in) -> {
            double d = in[0].getDouble((Script)sc) + 1.0;
            in[0].set((Script)sc, d);
            return d;
        });
        FunctionLoader.registerFunction("-=", (sc, in) -> {
            Double o = in[0].getDouble((Script)sc) - in[1].getDouble((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("p--", (sc, in) -> {
            double d = in[0].getDouble((Script)sc);
            in[0].set((Script)sc, d - 1.0);
            return d;
        });
        FunctionLoader.registerAlias("p--", "dec");
        FunctionLoader.registerFunction("--", (sc, in) -> {
            double d = in[0].getDouble((Script)sc) - 1.0;
            in[0].set((Script)sc, d);
            return d;
        });
        FunctionLoader.registerFunction("*=", (sc, in) -> {
            Double o = in[0].getDouble((Script)sc) * in[1].getDouble((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("/=", (sc, in) -> {
            Double o = in[0].getDouble((Script)sc) / in[1].getDouble((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("%=", (sc, in) -> {
            Double o = in[0].getInt((Script)sc) % in[1].getInt((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("<<=", (sc, in) -> {
            Double o = in[0].getInt((Script)sc) << in[1].getInt((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction(">>=", (sc, in) -> {
            Double o = in[0].getInt((Script)sc) >> in[1].getInt((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("&=", (sc, in) -> {
            Double o = in[0].getInt((Script)sc) & in[1].getInt((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("^=", (sc, in) -> {
            Double o = in[0].getInt((Script)sc) ^ in[1].getInt((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("|=", (sc, in) -> {
            Double o = in[0].getInt((Script)sc) | in[1].getInt((Script)sc);
            in[0].set((Script)sc, o);
            return o;
        });
        FunctionLoader.registerFunction("getvar", (sc, in) -> sc.getVar(in[0].getString((Script)sc)).get((Script)sc));
        FunctionLoader.registerFunction("setvar", (sc, in) -> {
            sc.getVar(in[0].getString((Script)sc)).set((Script)sc, in[1].get((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("removevar", (sc, in) -> {
            sc.getVar(in[0].getString((Script)sc)).set((Script)sc, null);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("wait", (sc, in) -> {
            sc.isWaiting = true;
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("try", (sc, in) -> {
            sc.catchLine = sc.currentLine + in[0].getInt((Script)sc);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("catch", (sc, in) -> {
            if (sc.catchLine != -1) {
                sc.currentLine += in[0].getInt((Script)sc);
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("function", (sc, in) -> {
            sc.currentLine += in[0].getInt((Script)sc);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("goto", (sc, in) -> {
            sc.currentLine = sc.getLabel(in[0].getString((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("ignoregoto", (sc, in) -> {
            Integer i = sc.getLabel(in[0].getString((Script)sc));
            if (i != null) {
                sc.currentLine = i;
            }
            return Void.TYPE;
        });
        FunctionLoader.registerAlias("ignoregoto", "igoto");
        FunctionLoader.registerFunction("sgoto", (sc, in) -> {
            int time = in[0].getInt((Script)sc);
            if (time < 0) {
                throw new IllegalArgumentException("time units can't be negative");
            }
            int label = sc.getLabel(in[1].getString((Script)sc));
            sc.scheduler.scheduleTask(() -> {
                if (!sc.isValid || sc.isHolded) {
                    return;
                }
                sc.currentLine = label + 1;
                sc.run();
                if (!sc.isValid) {
                    sc.parser.termUnsafe((Script)sc);
                }
            }, time);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("gosub", (sc, in) -> {
            sc.returnStack.push(sc.currentLine);
            sc.currentLine = sc.getLabel(in[0].getString((Script)sc));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("return", (sc, in) -> {
            if (sc.returnStack.isEmpty()) {
                sc.end();
                sc.returnValue = ((InputProvider[])in).length > 0 ? in[0].get((Script)sc) : null;
            } else if (sc.localVars.empty()) {
                sc.currentLine = sc.returnStack.pop();
            } else {
                sc.end();
                sc.returnValue = ((InputProvider[])in).length > 0 ? in[0].get((Script)sc) : null;
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("if", (sc, in) -> {
            sc.ifState = in[0].getBoolean((Script)sc);
            if (!sc.ifState) {
                sc.currentLine += in[1].getInt((Script)sc);
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("endif", (sc, in) -> {
            sc.ifState = true;
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("elseif", (sc, in) -> {
            if (sc.ifState) {
                sc.currentLine += in[1].getInt((Script)sc);
            } else {
                sc.ifState = in[0].getBoolean((Script)sc);
                if (!sc.ifState) {
                    sc.currentLine += in[1].getInt((Script)sc);
                }
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("else", (sc, in) -> {
            if (sc.ifState) {
                sc.currentLine += in[0].getInt((Script)sc);
            }
            sc.ifState = true;
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("while", (sc, in) -> {
            if (!in[0].getBoolean((Script)sc)) {
                sc.currentLine += in[1].getInt((Script)sc);
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("wend", (sc, in) -> {
            sc.currentLine += in[0].getInt((Script)sc);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("for", (sc, in) -> {
            double start = in[1].getDouble((Script)sc);
            in[0].set((Script)sc, start);
            if (start > in[2].getDouble((Script)sc)) {
                sc.currentLine += in[4].getInt((Script)sc);
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("next", (sc, in) -> {
            int line = sc.currentLine + in[0].getInt((Script)sc);
            InputProvider[] f = sc.code[line].getArguments();
            double current = f[0].getDouble((Script)sc) + f[3].getDouble((Script)sc);
            f[0].set((Script)sc, current);
            if (current <= f[2].getDouble((Script)sc)) {
                sc.currentLine = line;
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("continue", (sc, in) -> {
            sc.currentLine += in[0].getInt((Script)sc);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("break", (sc, in) -> {
            sc.currentLine += in[0].getInt((Script)sc);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("==", (sc, in) -> Objects.equals(in[0].get((Script)sc), in[1].get((Script)sc)));
        FunctionLoader.registerAlias("==", "equal");
        FunctionLoader.registerAlias("==", "equals");
        FunctionLoader.registerFunction("!=", (sc, in) -> !Objects.equals(in[0].get((Script)sc), in[1].get((Script)sc)));
        FunctionLoader.registerAlias("!=", "notequal");
        FunctionLoader.registerFunction("<", (sc, in) -> in[0].getDouble((Script)sc) < in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias("<", "less");
        FunctionLoader.registerFunction(">", (sc, in) -> in[0].getDouble((Script)sc) > in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias(">", "greater");
        FunctionLoader.registerFunction("<=", (sc, in) -> in[0].getDouble((Script)sc) <= in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias("<=", "lessequal");
        FunctionLoader.registerFunction(">=", (sc, in) -> in[0].getDouble((Script)sc) >= in[1].getDouble((Script)sc));
        FunctionLoader.registerAlias(">=", "greaterequal");
        FunctionLoader.registerFunction("!", (sc, in) -> !in[0].getBoolean((Script)sc));
        FunctionLoader.registerAlias("!", "invert");
        FunctionLoader.registerFunction("&&", (sc, in) -> {
            for (InputProvider i : in) {
                if (i.getBoolean((Script)sc)) continue;
                return false;
            }
            return true;
        });
        FunctionLoader.registerAlias("&&", "and");
        FunctionLoader.registerFunction("||", (sc, in) -> {
            for (InputProvider i : in) {
                if (!i.getBoolean((Script)sc)) continue;
                return true;
            }
            return false;
        });
        FunctionLoader.registerAlias("||", "or");
        FunctionLoader.registerFunction("swap", (sc, in) -> {
            Object o = in[0].get((Script)sc);
            in[0].set((Script)sc, in[1].get((Script)sc));
            in[1].set((Script)sc, o);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("print", (sc, in) -> {
            System.out.println(SnuviUtils.connect(sc, in, 0));
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("waitfor", (sc, in) -> {
            long l = in[0].getInt((Script)sc);
            if (l < 0L) {
                throw new IllegalArgumentException("time units can't be negative");
            }
            sc.isHolded = true;
            sc.scheduler.scheduleTask(() -> {
                if (sc.isValid) {
                    sc.isHolded = false;
                    sc.run();
                    if (!sc.isValid) {
                        sc.parser.termUnsafe((Script)sc);
                    }
                }
            }, l);
            sc.isWaiting = true;
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("term", (sc, in) -> {
            sc.parser.termSafe((Script)sc);
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("isdouble", (sc, in) -> in[0].get((Script)sc) instanceof Double);
        FunctionLoader.registerFunction("islong", (sc, in) -> {
            Object o = in[0].get((Script)sc);
            if (o instanceof Double) {
                double d = (Double)o;
                return d == (double)((long)d);
            }
            return false;
        });
        FunctionLoader.registerFunction("assert", (sc, in) -> {
            if (!in[0].getBoolean((Script)sc)) {
                throw new IllegalArgumentException("assertion failed");
            }
            return Void.TYPE;
        });
        FunctionLoader.registerFunction("class", (sc, in) -> in[0].get((Script)sc).getClass());
        FunctionLoader.registerFunction("usedmemory", (sc, in) -> {
            Runtime runtime = Runtime.getRuntime();
            double usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
            return usedMemory;
        });
        FunctionLoader.registerFunction("allocatedmemory", (sc, in) -> (double)Runtime.getRuntime().totalMemory() / 1048576.0);
    }
}

