/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.array;

import java.lang.reflect.Array;
import me.hammerle.snuviscript.code.InputProvider;
import me.hammerle.snuviscript.code.Script;
import me.hammerle.snuviscript.code.SnuviUtils;
import me.hammerle.snuviscript.variable.LocalVariable;
import me.hammerle.snuviscript.variable.Variable;

public class DynamicArray
extends InputProvider {
    protected Variable var;
    protected InputProvider[] input;

    public DynamicArray(Variable var, InputProvider[] input) {
        this.var = var;
        this.input = input;
    }

    public int getLength(Script sc) {
        return Array.getLength(this.var.getArray(sc));
    }

    public void init(Script sc) throws Exception {
        int[] dims = new int[this.input.length];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = this.input[i].getInt(sc);
        }
        this.var.set(sc, Array.newInstance(Object.class, dims));
    }

    @Override
    public Object getArray(Script sc) throws Exception {
        Object ob = this.var.getArray(sc);
        for (InputProvider in : this.input) {
            ob = Array.get(ob, in.getInt(sc));
        }
        return ob;
    }

    public Object getLastArray(Script sc) throws Exception {
        Object ob = this.var.getArray(sc);
        int end = this.input.length - 1;
        for (int j = 0; j < end; ++j) {
            ob = Array.get(ob, this.input[j].getInt(sc));
        }
        return ob;
    }

    @Override
    public void set(Script sc, Object o) throws Exception {
        Array.set(this.getLastArray(sc), this.input[this.input.length - 1].getInt(sc), o);
    }

    @Override
    public Object get(Script sc) throws Exception {
        return Array.get(this.getLastArray(sc), this.input[this.input.length - 1].getInt(sc));
    }

    @Override
    public double getDouble(Script sc) throws Exception {
        return (Double)this.get(sc);
    }

    @Override
    public String getString(Script sc) throws Exception {
        Object last = this.getLastArray(sc);
        int index = this.input[this.input.length - 1].getInt(sc);
        try {
            return String.valueOf(Array.get(last, index));
        }
        catch (IllegalArgumentException ex) {
            return SnuviUtils.getArrayString(Array.get(last, index));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.var.getName());
        if (this.var instanceof LocalVariable) {
            sb.append("#");
            sb.append("L");
        }
        sb.append("[");
        for (InputProvider in : this.input) {
            sb.append(in);
            sb.append(", ");
        }
        if (this.input.length > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("]");
        return sb.toString();
    }
}

