/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public final class ThreadLocalUtil {
    private static final long JNI_NATIVE_INTERFACE = ThreadLocalUtil.getThreadJNIEnv();
    private static final long FUNCTION_MISSING_ABORT = ThreadLocalUtil.getFunctionMissingAbort();

    private ThreadLocalUtil() {
    }

    private static native long getThreadJNIEnv();

    private static native void setThreadJNIEnv(long var0);

    private static native long jvmtiGetJNIFunctionTable();

    private static native void jvmtiDeallocate(long var0);

    private static native long getFunctionMissingAbort();

    public static void setEnv(long capabilities, int index) {
        if (Checks.CHECKS && (index < 0 || 3 < index)) {
            throw new IndexOutOfBoundsException();
        }
        long env = ThreadLocalUtil.getThreadJNIEnv();
        if (capabilities == 0L) {
            if (env != JNI_NATIVE_INTERFACE) {
                ThreadLocalUtil.setThreadJNIEnv(JNI_NATIVE_INTERFACE);
                ThreadLocalUtil.jvmtiDeallocate(env);
            }
        } else {
            if (env == JNI_NATIVE_INTERFACE) {
                env = ThreadLocalUtil.jvmtiGetJNIFunctionTable();
                ThreadLocalUtil.setThreadJNIEnv(env);
            }
            MemoryUtil.memPutAddress(env + (long)(index * Pointer.POINTER_SIZE), capabilities);
        }
    }

    public static PointerBuffer getAddressesFromCapabilities(Object caps) {
        List functions = Stream.of(caps.getClass().getFields()).filter(f -> f.getType() == Long.TYPE).collect(Collectors.toList());
        PointerBuffer addresses = BufferUtils.createPointerBuffer(functions.size());
        try {
            for (int i = 0; i < functions.size(); ++i) {
                long a = ((Field)functions.get(i)).getLong(caps);
                addresses.put(i, a != 0L ? a : FUNCTION_MISSING_ABORT);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return addresses;
    }

    public static boolean compareCapabilities(PointerBuffer ref, PointerBuffer caps) {
        for (int i = 0; i < ref.remaining(); ++i) {
            if (ref.get(i) == caps.get(i) || caps.get(i) == 0L) continue;
            return false;
        }
        return true;
    }
}

