/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.util;

public class Clock {
    private final int dataLength;
    private final long[] data;
    private int index = 0;
    private long sum = 0L;
    private long time;
    private boolean stable = false;
    private long min = Long.MAX_VALUE;
    private long avg = -1L;

    public Clock(int dataLength) {
        this.dataLength = dataLength;
        this.data = new long[dataLength];
    }

    public void start() {
        this.time = System.nanoTime();
    }

    public void stop() {
        this.time = System.nanoTime() - this.time;
        this.sum -= this.data[this.index];
        this.sum += this.time;
        this.data[this.index] = this.time;
        this.index = (this.index + 1) % this.dataLength;
        if (this.index == 0) {
            this.stable = true;
        }
    }

    public void calculate() {
        if (this.stable) {
            this.avg = this.sum / (long)this.dataLength;
            if (this.avg < this.min) {
                this.min = this.avg;
            }
        }
    }

    public long getTime() {
        if (this.stable) {
            return this.avg;
        }
        return -1L;
    }

    public long getMinTime() {
        if (this.stable) {
            return this.min;
        }
        return -1L;
    }
}

