/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.game;

import java.io.IOException;
import me.hammerle.snuviengine.api.Chunk;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.api.Texture;
import me.hammerle.snuviengine.game.Hero;
import me.hammerle.snuviengine.util.WrappedInputStream;
import me.hammerle.snuviengine.util.WrappedOutputStream;

public class World {
    private int width;
    private int height;
    private Chunk[][] chunks;
    private final Texture tiles = new Texture("images/tileset-blackvolution.png");
    private final Hero h;
    private float cameraX = 0.0f;
    private float cameraY = 0.0f;
    private float lastCameraX = 0.0f;
    private float lastCameraY = 0.0f;

    public World(Hero h) {
        this.h = h;
    }

    public void read(WrappedInputStream in) throws IOException {
        this.width = in.readInt();
        this.height = in.readInt();
        if (this.width % 8 != 0 || this.height % 8 != 0) {
            throw new IllegalArgumentException("world width and height must be a multiply of 8");
        }
        this.chunks = new Chunk[this.width / 8][this.height / 8];
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int y = 0; y < this.chunks[x].length; ++y) {
                this.chunks[x][y] = new Chunk(x, y);
                this.chunks[x][y].read(in);
            }
        }
    }

    public void write(WrappedOutputStream out) throws IOException {
        out.writeInt(this.width);
        out.writeInt(this.height);
        Chunk[][] chunkArray = this.chunks;
        int n = chunkArray.length;
        for (int i = 0; i < n; ++i) {
            Chunk[] chunk;
            for (Chunk c : chunk = chunkArray[i]) {
                c.write(out);
            }
        }
    }

    public void tick() {
        this.h.tick();
        this.lastCameraX = this.cameraX;
        this.lastCameraY = this.cameraY;
        this.cameraX = -this.getViewX((float)this.h.xPos);
        this.cameraY = -this.getViewY((float)this.h.yPos);
    }

    public void renderTick(float lag) {
        Chunk[] chunk;
        int n;
        Shader.translateTo(this.lastCameraX + (this.cameraX - this.lastCameraX) * lag, this.lastCameraY + (this.cameraY - this.lastCameraY) * lag);
        Shader.setLightLocation(0, 100.0f + this.lastCameraX + (this.cameraX - this.lastCameraX) * lag, 100.0f + this.lastCameraY + (this.cameraY - this.lastCameraY) * lag);
        Shader.setColorEnabled(false);
        Shader.setTextureEnabled(true);
        this.tiles.bind();
        Chunk[][] chunkArray = this.chunks;
        int n2 = chunkArray.length;
        for (n = 0; n < n2; ++n) {
            for (Chunk c : chunk = chunkArray[n]) {
                c.drawBackground();
            }
        }
        Shader.updateMatrix();
        Shader.setColorEnabled(true);
        Shader.setTextureEnabled(false);
        this.h.renderTick(lag);
        Shader.setColorEnabled(false);
        Shader.setTextureEnabled(true);
        this.tiles.bind();
        chunkArray = this.chunks;
        n2 = chunkArray.length;
        for (n = 0; n < n2; ++n) {
            for (Chunk c : chunk = chunkArray[n]) {
                c.drawForeground();
            }
        }
    }

    private float getViewX(float x) {
        if ((x -= (float)(Shader.getViewWidth() >> 1)) < 0.0f) {
            return 0.0f;
        }
        float max = this.width * 16 - Shader.getViewWidth();
        if (x > max) {
            return max;
        }
        return x;
    }

    private float getViewY(float y) {
        if ((y -= (float)(Shader.getViewHeight() >> 1)) < 0.0f) {
            return 0.0f;
        }
        float max = this.height * 16 - Shader.getViewHeight();
        if (y > max) {
            return max;
        }
        return y;
    }
}

