/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.game;

import java.io.FileInputStream;
import java.io.IOException;
import me.hammerle.snuviengine.api.Engine;
import me.hammerle.snuviengine.api.KeyBinding;
import me.hammerle.snuviengine.api.KeyHandler;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.api.TextureRenderer;
import me.hammerle.snuviengine.game.BoxList;
import me.hammerle.snuviengine.game.Entity;
import me.hammerle.snuviengine.game.Hero;
import me.hammerle.snuviengine.game.World;
import me.hammerle.snuviengine.util.Clock;
import me.hammerle.snuviengine.util.WrappedInputStream;

public class Game
extends Engine {
    public static final KeyBinding UP = KeyHandler.register(265);
    public static final KeyBinding DOWN = KeyHandler.register(264);
    public static final KeyBinding LEFT = KeyHandler.register(263);
    public static final KeyBinding RIGHT = KeyHandler.register(262);
    public static final KeyBinding KEY_F = KeyHandler.register(70);
    private boolean toogleFps = false;
    public static final KeyBinding KEY_T = KeyHandler.register(84);
    private boolean toogleTps = false;
    private final TextureRenderer tr = new TextureRenderer(12);
    public BoxList<Entity> entities = new BoxList(5000, 0.0, 0.0, 400.0, 300.0, 1.0);
    private World w;
    private static final Clock CLOCK = new Clock(250);

    public Game() {
        Hero hero = new Hero(this, 25.0, 25.0);
        hero.setPosition(0.0, 0.0);
        hero.node = this.entities.add(hero);
        this.w = new World(hero);
        try {
            this.w.read(new WrappedInputStream(new FileInputStream("./testworld")));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.setNanosPerTick(50000000L);
        Shader.setLightColor(0, 1.0f, 0.0f, 0.5f);
        Shader.setLightStrength(0, 0.01f);
        Shader.translateTo(0.0f, 0.0f);
        Shader.updateMatrix();
        Shader.setTextureEnabled(true);
        Shader.setColorEnabled(true);
    }

    @Override
    public void tick() {
    }

    @Override
    public void renderTick(float lag) {
        Shader.setLightEnabled(true);
        this.w.renderTick(lag);
    }

    @Override
    public void onStop() {
    }
}

