/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.game;

import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import me.hammerle.snuviengine.game.Entity;
import me.hammerle.snuviengine.game.IBoxListEntry;

public class BoxList<T extends IBoxListEntry> {
    private double maxWidth = 0.0;
    private double maxHeight = 0.0;
    private final T[] entities;
    private int lastFreeEntity;
    public boolean isIterating = false;
    private final double boxMinX;
    private final double boxMinY;
    private final double boxMaxX;
    private final double boxMaxY;
    private final double size;
    private final Node[][] nodes;
    private final int partionX;
    private final int partionY;
    public int amount = 0;

    public BoxList(int maxObjects, double x1, double y1, double x2, double y2, double size) {
        this.size = size;
        this.boxMinX = Math.min(x1, x2);
        this.boxMinY = Math.min(y1, y2);
        this.partionX = (int)Math.ceil((Math.max(x1, x2) - this.boxMinX) / size);
        this.partionY = (int)Math.ceil((Math.max(y1, y2) - this.boxMinX) / size);
        this.boxMaxX = (double)this.partionX * size;
        this.boxMaxY = (double)this.partionY * size;
        this.nodes = new Node[this.partionX][this.partionY];
        this.entities = new IBoxListEntry[maxObjects];
        this.lastFreeEntity = this.entities.length - 1;
    }

    public Node add(T ent) {
        if (this.isIterating) {
            throw new ConcurrentModificationException();
        }
        if (this.maxHeight < ent.getHeight() / 2.0) {
            this.maxHeight = ent.getHeight() / 2.0;
        }
        if (this.maxWidth < ent.getWidth() / 2.0) {
            this.maxWidth = ent.getWidth() / 2.0;
        }
        ++this.amount;
        int x = Math.max(Math.min((int)((ent.getCenterX() + this.boxMinX) / this.size), this.partionX - 1), 0);
        int y = Math.max(Math.min((int)((ent.getCenterY() + this.boxMinY) / this.size), this.partionY - 1), 0);
        Node n = new Node();
        n.index = this.lastFreeEntity;
        n.x = x;
        n.y = y;
        if (this.nodes[x][y] == null) {
            this.nodes[x][y] = n;
        } else {
            n.next = this.nodes[x][y];
            this.nodes[x][y].previous = n;
            this.nodes[x][y] = n;
        }
        this.entities[this.lastFreeEntity--] = ent;
        return n;
    }

    public void remove(Node n) {
        if (this.isIterating) {
            throw new ConcurrentModificationException();
        }
        if (n.previous != null) {
            n.previous.next = n.next;
        } else {
            this.nodes[((Node)n).x][((Node)n).y] = n.next;
        }
        if (n.next != null) {
            n.next.previous = n.previous;
        }
        if (this.lastFreeEntity + 1 == this.entities.length) {
            this.entities[((Node)n).index] = null;
        } else {
            T ent;
            ++this.lastFreeEntity;
            this.entities[((Node)n).index] = ent = this.entities[this.lastFreeEntity];
            ent.getNode().index = n.index;
            this.entities[this.lastFreeEntity] = null;
        }
        n.next = null;
        n.previous = null;
        --this.amount;
    }

    public void update(Entity ent) {
        int x = Math.max(Math.min((int)((ent.xPos + ent.width / 2.0 + this.boxMinX) / this.size), this.partionX - 1), 0);
        int y = Math.max(Math.min((int)((ent.yPos + ent.height / 2.0 + this.boxMinY) / this.size), this.partionY - 1), 0);
        Node n = ent.node;
        if (n.x == x && n.y == y) {
            return;
        }
        if (n.previous != null) {
            n.previous.next = n.next;
        } else {
            this.nodes[((Node)n).x][((Node)n).y] = n.next;
        }
        if (n.next != null) {
            n.next.previous = n.previous;
        }
        n.x = x;
        n.y = y;
        n.previous = null;
        if (this.nodes[x][y] == null) {
            this.nodes[x][y] = n;
            n.next = null;
        } else {
            n.next = this.nodes[x][y];
            this.nodes[x][y].previous = n;
            this.nodes[x][y] = n;
        }
    }

    public List<T> getAllEntitiesAt(T not, double minX, double minY, double maxX, double maxY) {
        int sx = Math.max(Math.min((int)((minX + this.boxMinX - this.maxWidth) / this.size), this.partionX - 1), 0);
        int sy = Math.max(Math.min((int)((minY + this.boxMinY - this.maxHeight) / this.size), this.partionY - 1), 0);
        int ex = Math.max(Math.min((int)((maxX + this.boxMinX + this.maxWidth) / this.size), this.partionX - 1), 0);
        int ey = Math.max(Math.min((int)((maxY + this.boxMinY + this.maxHeight) / this.size), this.partionY - 1), 0);
        LinkedList<T> list = new LinkedList<T>();
        for (int x = sx; x <= ex; ++x) {
            for (int y = sy; y <= ey; ++y) {
                Node n = this.nodes[x][y];
                while (n != null) {
                    if (not != this.entities[n.index] && this.entities[n.index].isColliding(minX, minY, maxX, maxY)) {
                        list.add(this.entities[n.index]);
                    }
                    n = n.next;
                }
            }
        }
        return list;
    }

    public void forEach(Consumer<T> c) {
        this.isIterating = true;
        for (int i = this.lastFreeEntity + 1; i < this.entities.length; ++i) {
            c.accept(this.entities[i]);
        }
        this.isIterating = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (T ent : this.entities) {
            sb.append(ent);
            sb.append(", ");
        }
        return sb.toString();
    }

    public static class Node {
        private Node next = null;
        private Node previous = null;
        private int index = -1;
        private int x = -1;
        private int y = -1;
    }
}

