/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.nio.FloatBuffer;
import me.hammerle.snuviengine.api.GLHelper;
import me.hammerle.snuviengine.api.Shader;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class Timer {
    private static final int SIZE = 128;
    private int index = -1;
    private final long[] times = new long[128];
    private long sum = 0L;
    private double callsPerSecond = 0.0;
    private long lastTime = System.nanoTime();
    private int vao;
    private int vbo;
    private final FloatBuffer buffer = BufferUtils.createFloatBuffer((int)18);
    private boolean active = false;
    private float expectedValue;

    protected Timer(float expectedValue) {
        this.expectedValue = expectedValue;
        Shader.addTask(() -> {
            this.vao = GL30.glGenVertexArrays();
            this.vbo = GL15.glGenBuffers();
            GLHelper.glBindVertexArray(this.vao);
            GLHelper.glBindBuffer(this.vbo);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)2);
            GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)12, (long)0L);
            GL20.glVertexAttribPointer((int)2, (int)4, (int)5121, (boolean)true, (int)12, (long)8L);
            GL15.glBufferData((int)34962, (long)(128 * this.buffer.limit() * 4), (int)35044);
        });
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    protected void update() {
        this.index = this.index + 1 & 0x7F;
        long time = System.nanoTime();
        this.sum -= this.times[this.index];
        this.times[this.index] = time - this.lastTime;
        this.sum += this.times[this.index];
        this.lastTime = time;
        this.callsPerSecond = 1.28E11 / (double)this.sum;
        if (this.active) {
            float minX = this.index * 3;
            float minY = 0.0f;
            float maxX = minX + 2.0f;
            float maxY = 1.0E9f / (float)this.times[this.index];
            float diff = (maxY - this.expectedValue) / this.expectedValue;
            int r = Math.min((int)(128.0f * (1.0f - Math.min(diff, 0.0f) * 16.0f)), 255);
            int g = Math.min((int)(128.0f * (1.0f + Math.max(diff, 0.0f) * 16.0f)), 255);
            int b = (int)(128.0f * (1.0f - Math.abs(diff)));
            float color = Float.intBitsToFloat(r | g << 8 | b << 16 | 0xFF000000);
            this.buffer.put(minX);
            this.buffer.put(maxY);
            this.buffer.put(color);
            this.buffer.put(minX);
            this.buffer.put(minY);
            this.buffer.put(color);
            this.buffer.put(maxX);
            this.buffer.put(maxY);
            this.buffer.put(color);
            this.buffer.put(minX);
            this.buffer.put(minY);
            this.buffer.put(color);
            this.buffer.put(maxX);
            this.buffer.put(maxY);
            this.buffer.put(color);
            this.buffer.put(maxX);
            this.buffer.put(minY);
            this.buffer.put(color);
            this.buffer.flip();
            GLHelper.glBindBuffer(this.vbo);
            GL15.glBufferSubData((int)34962, (long)(this.index * this.buffer.limit() * 4), (FloatBuffer)this.buffer);
        }
    }

    protected void setExpectedValue(float value) {
        this.expectedValue = value;
    }

    protected long getAverageTime() {
        return this.sum / 128L;
    }

    protected long getCurrentTime() {
        return System.nanoTime() - this.lastTime;
    }

    protected long getTime() {
        return this.times[this.index];
    }

    protected double getCallsPerSecond() {
        return this.callsPerSecond;
    }

    protected void draw() {
        if (this.active) {
            Shader.setTextureEnabled(false);
            Shader.setColorEnabled(true);
            GLHelper.glBindBuffer(this.vbo);
            GLHelper.glBindVertexArray(this.vao);
            GL11.glDrawArrays((int)4, (int)0, (int)768);
        }
    }
}

