/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.api.TextureException;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;

public class Texture {
    private int texture = -1;
    private final String path;
    private final int w;
    private final int h;
    private IntBuffer buffer;
    private static int textureUnits = 1;
    private int textureUnit = -1;
    private static int boundSampler = -1;
    private int sampler = -1;
    private int sampLoc = -1;

    public Texture(String path, boolean internal) {
        BufferedImage image;
        this.path = path;
        try {
            image = internal ? ImageIO.read(Texture.class.getClassLoader().getResource("me/hammerle/snuviengine/resources/" + path)) : ImageIO.read(new File(path));
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new TextureException("cannot read texture file '" + path + "'");
        }
        this.w = image.getWidth();
        this.h = image.getHeight();
        this.buffer = BufferUtils.createIntBuffer((int)(this.w * this.h));
        for (int y = 0; y < this.h; ++y) {
            for (int x = 0; x < this.w; ++x) {
                int c = image.getRGB(x, y);
                this.buffer.put(c << 8 | c >> 24 & 0xFF);
            }
        }
        this.buffer.flip();
        Shader.addTask(() -> this.loadTexture());
    }

    public Texture(String path) {
        this(path, false);
    }

    public Animation addAnimation(int offsetX, int offsetY, String ... paths) {
        return new Animation(offsetX, offsetY, paths);
    }

    private void loadTexture() {
        if (this.texture != -1) {
            throw new TextureException("a texture is already loaded");
        }
        this.sampler = GL33.glGenSamplers();
        this.sampLoc = GL20.glGetUniformLocation((int)Shader.getProgram(), (CharSequence)"samp");
        GL20.glUniform1i((int)this.sampLoc, (int)this.sampler);
        this.textureUnit = textureUnits++;
        GL33.glBindSampler((int)(33984 + this.textureUnit), (int)this.sampler);
        GL13.glActiveTexture((int)(33984 + this.textureUnit));
        this.texture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.w, (int)this.h, (int)0, (int)6408, (int)32821, (IntBuffer)this.buffer);
        this.buffer = null;
        GL30.glGenerateMipmap((int)3553);
    }

    public void bind() {
        if (this.texture == -1) {
            throw new TextureException("cannot load non loaded texture");
        }
        if (boundSampler != this.sampler) {
            boundSampler = this.sampler;
            GL20.glUniform1i((int)this.sampLoc, (int)this.sampler);
        }
    }

    public class Animation {
        private IntBuffer[] data;
        private int[] wi;
        private int[] he;
        private final int offsetX;
        private final int offsetY;
        private int index = 0;

        private Animation(int offsetX, int offsetY, String ... paths) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            int l = paths.length;
            this.data = new IntBuffer[l];
            this.wi = new int[l];
            this.he = new int[l];
            for (int i = 0; i < l; ++i) {
                BufferedImage image;
                try {
                    image = ImageIO.read(new File(paths[i]));
                }
                catch (IOException | IllegalArgumentException ex) {
                    throw new TextureException("cannot read texture file '" + paths[i] + "'");
                }
                if (offsetX + image.getWidth() > Texture.this.w || offsetY + image.getHeight() > Texture.this.h) {
                    System.out.println(offsetX + " " + image.getWidth() + " " + Texture.this.w + " " + offsetY + " " + image.getHeight() + " " + Texture.this.h);
                    throw new TextureException("animation image '" + paths[i] + "'is out of range");
                }
                this.wi[i] = image.getWidth();
                this.he[i] = image.getHeight();
                IntBuffer buffer = BufferUtils.createIntBuffer((int)(this.wi[i] * this.he[i]));
                for (int y = 0; y < this.he[i]; ++y) {
                    for (int x = 0; x < this.wi[i]; ++x) {
                        int c = image.getRGB(x, y);
                        buffer.put(c << 8 | c >> 24 & 0xFF);
                    }
                }
                buffer.flip();
                this.data[i] = buffer;
            }
        }

        public void nextFrame() {
            GL13.glActiveTexture((int)(33984 + Texture.this.textureUnit));
            GL11.glTexSubImage2D((int)3553, (int)0, (int)this.offsetX, (int)this.offsetY, (int)this.wi[this.index], (int)this.he[this.index], (int)6408, (int)32821, (IntBuffer)this.data[this.index]);
            this.index = (this.index + 1) % this.data.length;
        }
    }
}

