/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import me.hammerle.snuviengine.api.ShaderException;

public class MatrixStack {
    private final int capacity;
    private final float[][] stack;
    private int index = 0;

    protected MatrixStack(int capacity) {
        this.capacity = capacity;
        this.stack = new float[capacity][16];
        this.stack[this.index][0] = 1.0f;
        this.stack[this.index][5] = 1.0f;
        this.stack[this.index][10] = 1.0f;
        this.stack[this.index][15] = 1.0f;
    }

    protected float[] getData() {
        return this.stack[this.index];
    }

    protected void push() {
        ++this.index;
        if (this.index >= this.capacity) {
            throw new ShaderException("matrix stack overflow, max capacity is " + this.capacity);
        }
        System.arraycopy(this.stack[this.index - 1], 0, this.stack[this.index], 0, 16);
    }

    protected void pop() {
        if (this.index <= 0) {
            throw new ShaderException("matrix stack underflow");
        }
        --this.index;
    }

    protected void scale(float sx, float sy) {
        float[] fArray = this.stack[this.index];
        fArray[0] = fArray[0] * sx;
        float[] fArray2 = this.stack[this.index];
        fArray2[1] = fArray2[1] * sx;
        float[] fArray3 = this.stack[this.index];
        fArray3[4] = fArray3[4] * sy;
        float[] fArray4 = this.stack[this.index];
        fArray4[5] = fArray4[5] * sy;
    }

    protected void translate(float tx, float ty) {
        float[] fArray = this.stack[this.index];
        fArray[12] = fArray[12] + (this.stack[this.index][0] * tx + this.stack[this.index][4] * ty);
        float[] fArray2 = this.stack[this.index];
        fArray2[13] = fArray2[13] + (this.stack[this.index][1] * tx + this.stack[this.index][5] * ty);
    }

    protected void translateTo(float tx, float ty) {
        this.stack[this.index][0] = 1.0f;
        this.stack[this.index][1] = 0.0f;
        this.stack[this.index][4] = 0.0f;
        this.stack[this.index][5] = 1.0f;
        this.stack[this.index][12] = tx;
        this.stack[this.index][13] = ty;
    }

    protected void rotate(float angle) {
        angle = (float)Math.toRadians(angle);
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        float a1 = this.stack[this.index][0];
        float a2 = this.stack[this.index][4];
        this.stack[this.index][0] = a1 * cos - a2 * sin;
        this.stack[this.index][4] = a1 * sin + a2 * cos;
        a1 = this.stack[this.index][1];
        a2 = this.stack[this.index][5];
        this.stack[this.index][1] = a1 * cos - a2 * sin;
        this.stack[this.index][5] = a1 * sin + a2 * cos;
    }
}

