/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.io.PrintStream;
import me.hammerle.snuviengine.api.KeyHandler;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.api.Timer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public abstract class Engine {
    private static final String VERSION = "0.0.1";
    public static final int TILE_SIZE = 16;
    public static final float SCALE = 2.0f;
    private long window;
    private long fpsLimit = -1L;
    private long sleep = 0L;
    private long nanosPerTick = 10000000L;
    private final int maxTicksPerFrame = 20;
    private final Timer fps = new Timer(60.0f);
    private final Timer tps = new Timer(1000000000L / this.nanosPerTick);

    public final void run() {
        this.initGLFW();
        this.loop();
        Callbacks.glfwFreeCallbacks((long)this.window);
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
        GLFWErrorCallback error = GLFW.glfwSetErrorCallback(null);
        if (error != null) {
            error.free();
        }
    }

    public final void stop() {
        GLFW.glfwSetWindowShouldClose((long)this.window, (boolean)true);
    }

    private void initGLFW() {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)139266, (int)4);
        GLFW.glfwWindowHint((int)139267, (int)0);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        this.window = GLFW.glfwCreateWindow((int)1024, (int)620, (CharSequence)"SnuviEngine 0.0.1", (long)0L, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        GLFW.glfwSetKeyCallback((long)this.window, (w, key, scancode, action, mods) -> {
            if (action == 0) {
                KeyHandler.onKeyUpEvent(key);
            } else if (action == 1) {
                KeyHandler.onKeyDownEvent(key);
            }
        });
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, (w, fwidth, fheight) -> {
            GL11.glViewport((int)0, (int)0, (int)fwidth, (int)fheight);
            Shader.setViewPort(fwidth, fheight);
        });
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        GLFW.glfwShowWindow((long)this.window);
    }

    private void sleep(long nanos) {
        if (nanos < 0L) {
            this.sleep += nanos;
            return;
        }
        if (this.sleep < 0L) {
            this.sleep += nanos / 4L;
            nanos = nanos * 3L / 4L;
        }
        long end = System.nanoTime() + nanos - 10000L;
        try {
            Thread.sleep(nanos / 1000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int i = 0;
        while (System.nanoTime() < end) {
            ++i;
        }
    }

    private void loop() {
        GL.createCapabilities();
        Shader.init();
        this.init();
        this.fps.update();
        this.tps.update();
        long lag = 0L;
        while (!GLFW.glfwWindowShouldClose((long)this.window)) {
            GLFW.glfwSwapBuffers((long)this.window);
            GL11.glClear((int)16640);
            if (this.fpsLimit > 0L) {
                this.sleep(this.fpsLimit - this.fps.getCurrentTime());
            }
            this.fps.update();
            lag += this.fps.getTime();
            int ticksPerFrame = 0;
            while (lag >= this.nanosPerTick) {
                lag -= this.nanosPerTick;
                this.tps.update();
                KeyHandler.tick();
                this.tick();
                if (++ticksPerFrame < 20) continue;
                long skip = lag / this.nanosPerTick;
                lag -= skip * this.nanosPerTick;
                if (skip <= 0L) break;
                System.out.println("skipped " + skip + " game ticks " + lag);
                break;
            }
            Shader.doTasks();
            this.renderTick((float)lag / (float)this.nanosPerTick);
            this.tps.draw();
            this.fps.draw();
            GLFW.glfwPollEvents();
        }
        this.onStop();
    }

    public final void setNanosPerTick(long nanos) {
        this.nanosPerTick = nanos;
        this.tps.setExpectedValue(1000000000L / nanos);
    }

    public final long getNanosPerTick() {
        return this.nanosPerTick;
    }

    public final double getTps() {
        return this.tps.getCallsPerSecond();
    }

    public final void setRenderTps(boolean active) {
        this.tps.setActive(active);
    }

    public final double getFps() {
        return this.fps.getCallsPerSecond();
    }

    public final void setMaxFps(int max) {
        this.fpsLimit = 1000000000 / max;
    }

    public final void setRenderFps(boolean active) {
        this.fps.setActive(active);
    }

    public abstract void init();

    public abstract void tick();

    public abstract void renderTick(float var1);

    public abstract void onStop();
}

