/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.io.IOException;
import java.nio.FloatBuffer;
import me.hammerle.snuviengine.api.GLHelper;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.util.WrappedInputStream;
import me.hammerle.snuviengine.util.WrappedOutputStream;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class Chunk {
    public static final int CHUNK_SIZE = 8;
    public static final int TILE_SIZE = 16;
    public static final int LAYERS = 4;
    public static final int LAST_BACK_LAYER = 1;
    private final short[][][] data = new short[4][8][8];
    private final int chunkX;
    private final int chunkY;
    private int vao;
    private int vbo;
    private final FloatBuffer buffer = BufferUtils.createFloatBuffer((int)1536);
    private boolean[] dirty = new boolean[4];

    public Chunk(int x, int y) {
        this.chunkX = x;
        this.chunkY = y;
        for (int i = 0; i < 4; ++i) {
            this.dirty[i] = true;
        }
        Shader.addTask(() -> {
            this.vao = GL30.glGenVertexArrays();
            this.vbo = GL15.glGenBuffers();
            GLHelper.glBindVertexArray(this.vao);
            GLHelper.glBindBuffer(this.vbo);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)16, (long)0L);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)16, (long)8L);
            GL15.glBufferData((int)34962, (long)24576L, (int)35044);
        });
    }

    public void read(WrappedInputStream in) throws IOException {
        for (int l = 0; l < 4; ++l) {
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    this.data[l][x][y] = in.readShort();
                }
            }
        }
    }

    public void write(WrappedOutputStream out) throws IOException {
        for (int l = 0; l < 4; ++l) {
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    out.writeShort(this.data[l][x][y]);
                }
            }
        }
    }

    private void rebuild(int layer) {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                short tile = this.data[layer][x][y];
                float minX = x * 16;
                float minY = y * 16;
                float maxX = minX + 16.0f;
                float maxY = minY + 16.0f;
                float tMinX = (float)(tile % 8) * 0.125f;
                float tMinY = (float)(tile / 8) * 0.010869565f;
                float tMaxX = tMinX + 0.125f;
                float tMaxY = tMinY + 0.010869565f;
                this.buffer.put(minX);
                this.buffer.put(maxY);
                this.buffer.put(tMinX);
                this.buffer.put(tMaxY);
                this.buffer.put(minX);
                this.buffer.put(minY);
                this.buffer.put(tMinX);
                this.buffer.put(tMinY);
                this.buffer.put(maxX);
                this.buffer.put(maxY);
                this.buffer.put(tMaxX);
                this.buffer.put(tMaxY);
                this.buffer.put(maxX);
                this.buffer.put(maxY);
                this.buffer.put(tMaxX);
                this.buffer.put(tMaxY);
                this.buffer.put(minX);
                this.buffer.put(minY);
                this.buffer.put(tMinX);
                this.buffer.put(tMinY);
                this.buffer.put(maxX);
                this.buffer.put(minY);
                this.buffer.put(tMaxX);
                this.buffer.put(tMinY);
            }
        }
        this.buffer.flip();
        GLHelper.glBindVertexArray(this.vao);
        GLHelper.glBindBuffer(this.vbo);
        GL15.glBufferSubData((int)34962, (long)(6144 * layer), (FloatBuffer)this.buffer);
    }

    public void drawBackground() {
        for (int i = 0; i <= 1; ++i) {
            if (!this.dirty[i]) continue;
            this.rebuild(i);
            this.dirty[i] = false;
        }
        GLHelper.glBindVertexArray(this.vao);
        GLHelper.glBindBuffer(this.vbo);
        Shader.pushMatrix();
        Shader.translate(this.chunkX * 8 * 16, this.chunkY * 8 * 16);
        Shader.updateMatrix();
        Shader.popMatrix();
        GL11.glDrawArrays((int)4, (int)0, (int)768);
    }

    public void drawForeground() {
        for (int i = 2; i < 4; ++i) {
            if (!this.dirty[i]) continue;
            this.rebuild(i);
            this.dirty[i] = false;
        }
        GLHelper.glBindVertexArray(this.vao);
        GLHelper.glBindBuffer(this.vbo);
        Shader.pushMatrix();
        Shader.translate(this.chunkX * 8 * 16, this.chunkY * 8 * 16);
        Shader.updateMatrix();
        Shader.popMatrix();
        GL11.glDrawArrays((int)4, (int)768, (int)768);
    }
}

