/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.text;

import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import me.hammerle.text.CharacterDesign;
import me.hammerle.text.SnuviCharPainter;

public class SnuviTextPainter {
    private final GraphicsContext context;
    private final SnuviCharPainter painter;
    private double scale;

    public SnuviTextPainter(Canvas canvas) {
        this.context = canvas.getGraphicsContext2D();
        this.painter = new SnuviCharPainter(this.context);
        this.scale = 1.0;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getBaseWidth() {
        return 8.0;
    }

    public double getBaseHeight() {
        return 8.0;
    }

    public double getHeight(int i) {
        return (double)(i * 8) * this.scale;
    }

    public double getWidth(int i) {
        return (double)(i * 8) * this.scale;
    }

    public void prepareStringDrawing(Color c, double scale) {
        this.context.save();
        this.context.setStroke((Paint)c);
        this.context.setFill((Paint)c);
        this.setScale(scale);
    }

    public void stopStringDrawing() {
        this.context.restore();
    }

    public double paintString(char[] chars, double x, double y, int max) {
        max = Math.min(chars.length, max);
        double oldWidth = this.context.getLineWidth();
        this.context.setLineWidth(this.scale);
        for (int i = 0; i < max; ++i) {
            CharacterDesign design = this.painter.getDesign(chars[i]);
            design.paint(x, y, this.scale);
            x += this.scale * 8.0;
        }
        this.context.setLineWidth(oldWidth);
        return this.getWidth(max);
    }
}

