/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.text;

import java.util.Arrays;
import java.util.function.Consumer;
import javafx.scene.canvas.GraphicsContext;
import me.hammerle.text.CharacterDesign;

public class SnuviCharPainter {
    private final GraphicsContext context;
    private final CharacterDesign[] designs;

    public SnuviCharPainter(GraphicsContext context) {
        this.context = context;
        this.designs = new CharacterDesign[256];
        this.initChars();
    }

    private void initChar(int c, Consumer<CharacterDesign> painter) {
        this.designs[c] = new CharacterDesign(this.context, painter);
    }

    private void initChars() {
        this.initChar(0, cd -> {});
        Arrays.fill(this.designs, this.designs[0]);
        this.initSpecialCharacters();
        this.initDigits();
        this.initUpperLetters();
        this.initLowerLetters();
        this.initSpecialLetters();
        this.initNewCharacters();
    }

    private void initLowerLetters() {
        this.initChar(97, cd -> {
            cd.drawLine(1, 2, 3, 2);
            cd.drawLine(4, 3, 4, 6);
            cd.drawLine(1, 4, 4, 4);
            cd.drawLine(1, 6, 4, 6);
            cd.drawLine(0, 5, 0, 5);
        });
        this.initChar(98, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 2, 3, 2);
            cd.drawLine(0, 6, 3, 6);
            cd.drawLine(4, 3, 4, 5);
        });
        this.initChar(99, cd -> {
            cd.drawLine(0, 3, 0, 5);
            cd.drawLine(1, 2, 4, 2);
            cd.drawLine(1, 6, 4, 6);
        });
        this.initChar(100, cd -> {
            cd.drawLine(4, 0, 4, 6);
            cd.drawLine(1, 2, 4, 2);
            cd.drawLine(1, 6, 4, 6);
            cd.drawLine(0, 3, 0, 5);
        });
        this.initChar(101, cd -> {
            cd.drawLine(1, 2, 3, 2);
            cd.drawLine(0, 4, 4, 4);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(0, 3, 0, 5);
            cd.drawLine(4, 3, 4, 4);
        });
        this.initChar(102, cd -> {
            cd.drawLine(0, 3, 4, 3);
            cd.drawLine(2, 1, 2, 6);
            cd.drawLine(3, 0, 4, 0);
        });
        this.initChar(103, cd -> {
            cd.drawLine(1, 2, 4, 2);
            cd.drawLine(0, 3, 0, 4);
            cd.drawLine(1, 5, 4, 5);
            cd.drawLine(1, 7, 3, 7);
            cd.drawLine(4, 2, 4, 6);
        });
        this.initChar(104, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 3, 1, 3);
            cd.drawLine(2, 2, 3, 2);
            cd.drawLine(4, 3, 4, 6);
        });
        this.initChar(105, cd -> {
            cd.drawLine(2, 0, 2, 0);
            cd.drawLine(2, 2, 2, 6);
            cd.drawLine(1, 2, 2, 2);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(106, cd -> {
            cd.drawLine(4, 0, 4, 0);
            cd.drawLine(4, 2, 4, 6);
            cd.drawLine(3, 2, 4, 2);
            cd.drawLine(1, 7, 3, 7);
            cd.drawLine(0, 6, 0, 6);
        });
        this.initChar(107, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(4, 2, 4, 2);
            cd.drawLine(3, 3, 3, 3);
            cd.drawLine(2, 4, 2, 4);
            cd.drawLine(0, 5, 1, 5);
            cd.drawLine(3, 5, 3, 5);
            cd.drawLine(4, 6, 4, 6);
        });
        this.initChar(108, cd -> {
            cd.drawLine(1, 0, 2, 0);
            cd.drawLine(2, 0, 2, 6);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(109, cd -> {
            cd.drawLine(0, 2, 3, 2);
            cd.drawLine(0, 2, 0, 6);
            cd.drawLine(2, 2, 2, 6);
            cd.drawLine(4, 3, 4, 6);
        });
        this.initChar(110, cd -> {
            cd.drawLine(0, 2, 3, 2);
            cd.drawLine(0, 2, 0, 6);
            cd.drawLine(4, 3, 4, 6);
        });
        this.initChar(111, cd -> {
            cd.drawLine(1, 2, 3, 2);
            cd.drawLine(0, 3, 0, 5);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(4, 3, 4, 5);
        });
        this.initChar(112, cd -> {
            cd.drawLine(0, 2, 3, 2);
            cd.drawLine(0, 5, 3, 5);
            cd.drawLine(0, 2, 0, 7);
            cd.drawLine(4, 3, 4, 4);
        });
        this.initChar(113, cd -> {
            cd.drawLine(1, 2, 4, 2);
            cd.drawLine(1, 5, 4, 5);
            cd.drawLine(4, 2, 4, 7);
            cd.drawLine(0, 3, 0, 4);
        });
        this.initChar(114, cd -> {
            cd.drawLine(2, 2, 3, 2);
            cd.drawLine(0, 2, 0, 6);
            cd.drawLine(1, 3, 1, 3);
            cd.drawLine(4, 3, 4, 3);
        });
        this.initChar(115, cd -> {
            cd.drawLine(1, 2, 4, 2);
            cd.drawLine(1, 4, 3, 4);
            cd.drawLine(0, 6, 3, 6);
            cd.drawLine(0, 3, 0, 3);
            cd.drawLine(4, 5, 4, 5);
        });
        this.initChar(116, cd -> {
            cd.drawLine(0, 2, 4, 2);
            cd.drawLine(2, 0, 2, 5);
            cd.drawLine(3, 6, 4, 6);
        });
        this.initChar(117, cd -> {
            cd.drawLine(0, 2, 0, 5);
            cd.drawLine(4, 2, 4, 6);
            cd.drawLine(1, 6, 4, 6);
        });
        this.initChar(118, cd -> {
            cd.drawLine(0, 2, 0, 4);
            cd.drawLine(4, 2, 4, 4);
            cd.drawLine(1, 5, 1, 5);
            cd.drawLine(3, 5, 3, 5);
            cd.drawLine(2, 6, 2, 6);
        });
        this.initChar(119, cd -> {
            cd.drawLine(0, 2, 0, 5);
            cd.drawLine(4, 2, 4, 5);
            cd.drawLine(1, 6, 1, 6);
            cd.drawLine(3, 6, 3, 6);
            cd.drawLine(2, 3, 2, 5);
        });
        this.initChar(120, cd -> {
            cd.drawLine(0, 2, 0, 2);
            cd.drawLine(4, 2, 4, 2);
            cd.drawLine(1, 3, 1, 3);
            cd.drawLine(3, 3, 3, 3);
            cd.drawLine(2, 4, 2, 4);
            cd.drawLine(1, 5, 1, 5);
            cd.drawLine(3, 5, 3, 5);
            cd.drawLine(0, 6, 0, 6);
            cd.drawLine(4, 6, 4, 6);
        });
        this.initChar(121, cd -> {
            cd.drawLine(0, 2, 0, 4);
            cd.drawLine(4, 2, 4, 6);
            cd.drawLine(1, 5, 4, 5);
            cd.drawLine(1, 7, 3, 7);
        });
        this.initChar(122, cd -> {
            cd.drawLine(0, 2, 4, 2);
            cd.drawLine(3, 2, 3, 3);
            cd.drawLine(2, 4, 2, 4);
            cd.drawLine(1, 5, 1, 6);
            cd.drawLine(0, 6, 4, 6);
        });
    }

    private void initUpperLetters() {
        this.initChar(65, cd -> {
            cd.drawLine(0, 2, 0, 6);
            cd.drawLine(4, 2, 4, 6);
            cd.drawLine(0, 3, 4, 3);
            cd.drawLine(2, 0, 2, 0);
            cd.drawLine(1, 1, 1, 1);
            cd.drawLine(3, 1, 3, 1);
        });
        this.initChar(66, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 0, 3, 0);
            cd.drawLine(0, 3, 3, 3);
            cd.drawLine(0, 6, 3, 6);
            cd.drawLine(4, 1, 4, 2);
            cd.drawLine(4, 4, 4, 5);
        });
        this.initChar(67, cd -> {
            cd.drawLine(0, 1, 0, 5);
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(4, 1, 4, 1);
            cd.drawLine(4, 5, 4, 5);
        });
        this.initChar(68, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 0, 2, 0);
            cd.drawLine(0, 6, 2, 6);
            cd.drawLine(4, 2, 4, 4);
            cd.drawLine(3, 1, 3, 1);
            cd.drawLine(3, 5, 3, 5);
        });
        this.initChar(69, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 0, 4, 0);
            cd.drawLine(0, 3, 3, 3);
            cd.drawLine(0, 6, 4, 6);
        });
        this.initChar(70, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 0, 4, 0);
            cd.drawLine(0, 3, 3, 3);
        });
        this.initChar(71, cd -> {
            cd.drawLine(0, 1, 0, 5);
            cd.drawLine(1, 0, 4, 0);
            cd.drawLine(1, 6, 4, 6);
            cd.drawLine(4, 3, 4, 6);
            cd.drawLine(2, 3, 4, 3);
        });
        this.initChar(72, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(4, 0, 4, 6);
            cd.drawLine(0, 3, 4, 3);
        });
        this.initChar(73, cd -> {
            cd.drawLine(2, 0, 2, 6);
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(74, cd -> {
            cd.drawLine(2, 0, 4, 0);
            cd.drawLine(3, 0, 3, 5);
            cd.drawLine(0, 5, 0, 5);
            cd.drawLine(1, 6, 2, 6);
        });
        this.initChar(75, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(4, 0, 4, 0);
            cd.drawLine(3, 1, 3, 1);
            cd.drawLine(2, 2, 2, 2);
            cd.drawLine(0, 3, 1, 3);
            cd.drawLine(2, 4, 2, 4);
            cd.drawLine(3, 5, 3, 5);
            cd.drawLine(4, 6, 4, 6);
        });
        this.initChar(76, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 6, 4, 6);
        });
        this.initChar(77, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(4, 0, 4, 6);
            cd.drawLine(0, 1, 1, 1);
            cd.drawLine(3, 1, 4, 1);
            cd.drawLine(2, 2, 2, 2);
        });
        this.initChar(78, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(4, 0, 4, 6);
            cd.drawLine(0, 1, 1, 1);
            cd.drawLine(3, 3, 4, 3);
            cd.drawLine(2, 2, 2, 2);
        });
        this.initChar(79, cd -> {
            cd.drawLine(0, 1, 0, 5);
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(4, 1, 4, 5);
        });
        this.initChar(80, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 0, 3, 0);
            cd.drawLine(0, 3, 3, 3);
            cd.drawLine(4, 1, 4, 2);
        });
        this.initChar(81, cd -> {
            cd.drawLine(0, 1, 0, 5);
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(1, 6, 2, 6);
            cd.drawLine(4, 1, 4, 4);
            cd.drawLine(3, 5, 3, 5);
            cd.drawLine(4, 6, 4, 6);
            cd.drawLine(2, 4, 2, 4);
        });
        this.initChar(82, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(0, 0, 3, 0);
            cd.drawLine(0, 3, 3, 3);
            cd.drawLine(4, 1, 4, 2);
            cd.drawLine(2, 3, 2, 4);
            cd.drawLine(3, 5, 3, 5);
            cd.drawLine(4, 6, 4, 6);
        });
        this.initChar(83, cd -> {
            cd.drawLine(4, 1, 4, 1);
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(1, 3, 3, 3);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(0, 1, 0, 2);
            cd.drawLine(4, 4, 4, 5);
            cd.drawLine(0, 5, 0, 5);
        });
        this.initChar(84, cd -> {
            cd.drawLine(0, 0, 4, 0);
            cd.drawLine(2, 0, 2, 6);
        });
        this.initChar(85, cd -> {
            cd.drawLine(0, 0, 0, 5);
            cd.drawLine(4, 0, 4, 5);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(86, cd -> {
            cd.drawLine(0, 0, 0, 2);
            cd.drawLine(4, 0, 4, 2);
            cd.drawLine(1, 3, 1, 4);
            cd.drawLine(3, 3, 3, 4);
            cd.drawLine(2, 5, 2, 6);
        });
        this.initChar(87, cd -> {
            cd.drawLine(0, 0, 0, 6);
            cd.drawLine(4, 0, 4, 6);
            cd.drawLine(0, 5, 1, 5);
            cd.drawLine(3, 5, 4, 5);
            cd.drawLine(2, 4, 2, 4);
        });
        this.initChar(88, cd -> {
            cd.drawLine(0, 0, 0, 1);
            cd.drawLine(4, 0, 4, 1);
            cd.drawLine(0, 5, 0, 6);
            cd.drawLine(4, 5, 4, 6);
            cd.drawLine(1, 2, 1, 2);
            cd.drawLine(2, 3, 2, 3);
            cd.drawLine(3, 4, 3, 4);
            cd.drawLine(1, 4, 1, 4);
            cd.drawLine(3, 2, 3, 2);
        });
        this.initChar(89, cd -> {
            cd.drawLine(0, 0, 0, 1);
            cd.drawLine(4, 0, 4, 1);
            cd.drawLine(1, 2, 1, 2);
            cd.drawLine(2, 3, 2, 6);
            cd.drawLine(3, 2, 3, 2);
        });
        this.initChar(90, cd -> {
            cd.drawLine(0, 0, 4, 0);
            cd.drawLine(4, 0, 4, 1);
            cd.drawLine(3, 2, 3, 2);
            cd.drawLine(2, 3, 2, 3);
            cd.drawLine(1, 4, 1, 4);
            cd.drawLine(0, 5, 0, 6);
            cd.drawLine(0, 6, 4, 6);
        });
    }

    private void initSpecialLetters() {
        this.initChar(196, cd -> {
            cd.drawLine(0, 2, 0, 6);
            cd.drawLine(4, 2, 4, 6);
            cd.drawLine(0, 3, 4, 3);
            cd.drawLine(1, 1, 3, 1);
            cd.drawPoint(1, -1);
            cd.drawPoint(3, -1);
        });
        this.initChar(228, cd -> {
            cd.drawLine(1, 2, 3, 2);
            cd.drawLine(4, 3, 4, 6);
            cd.drawLine(1, 4, 4, 4);
            cd.drawLine(1, 6, 4, 6);
            cd.drawLine(0, 5, 0, 5);
            cd.drawPoint(1, 0);
            cd.drawPoint(3, 0);
        });
        this.initChar(214, cd -> {
            cd.drawLine(0, 2, 0, 5);
            cd.drawLine(1, 1, 3, 1);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(4, 2, 4, 5);
            cd.drawPoint(1, -1);
            cd.drawPoint(3, -1);
        });
        this.initChar(246, cd -> {
            cd.drawLine(1, 2, 3, 2);
            cd.drawLine(0, 3, 0, 5);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(4, 3, 4, 5);
            cd.drawPoint(1, 0);
            cd.drawPoint(3, 0);
        });
        this.initChar(220, cd -> {
            cd.drawLine(0, 1, 0, 5);
            cd.drawLine(4, 1, 4, 5);
            cd.drawLine(1, 6, 3, 6);
            cd.drawPoint(1, -1);
            cd.drawPoint(3, -1);
        });
        this.initChar(252, cd -> {
            cd.drawLine(0, 2, 0, 5);
            cd.drawLine(4, 2, 4, 6);
            cd.drawLine(1, 6, 4, 6);
            cd.drawPoint(1, 0);
            cd.drawPoint(3, 0);
        });
        this.initChar(223, cd -> {
            cd.drawLine(0, 1, 0, 7);
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(2, 3, 3, 3);
            cd.drawLine(2, 6, 3, 6);
            cd.drawLine(4, 1, 4, 2);
            cd.drawLine(4, 4, 4, 5);
        });
    }

    private void initDigits() {
        this.initChar(48, cd -> {
            cd.drawLine(0, 1, 0, 5);
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(1, 6, 3, 6);
            cd.drawLine(4, 1, 4, 5);
            cd.drawLine(3, 2, 4, 2);
            cd.drawLine(2, 3, 2, 3);
            cd.drawLine(0, 4, 1, 4);
        });
        this.initChar(49, cd -> {
            cd.drawLine(2, 0, 2, 6);
            cd.drawLine(0, 1, 2, 1);
            cd.drawLine(0, 6, 4, 6);
        });
        this.initChar(50, cd -> {
            cd.drawLine(1, 0, 3, 0);
            cd.drawPoint(0, 1);
            cd.drawLine(4, 1, 4, 2);
            cd.drawLine(3, 3, 3, 3);
            cd.drawLine(2, 4, 2, 4);
            cd.drawLine(1, 5, 1, 6);
            cd.drawLine(0, 6, 4, 6);
        });
        this.initChar(51, cd -> {
            cd.drawLine(1, 0, 3, 0);
            cd.drawPoint(0, 1);
            cd.drawLine(4, 1, 4, 2);
            cd.drawLine(2, 3, 3, 3);
            cd.drawLine(4, 4, 4, 5);
            cd.drawPoint(0, 5);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(52, cd -> {
            cd.drawLine(3, 0, 3, 6);
            cd.drawLine(2, 1, 3, 1);
            cd.drawPoint(1, 2);
            cd.drawLine(0, 3, 0, 5);
            cd.drawLine(0, 5, 4, 5);
        });
        this.initChar(53, cd -> {
            cd.drawLine(0, 0, 4, 0);
            cd.drawLine(0, 0, 0, 3);
            cd.drawLine(0, 2, 3, 2);
            cd.drawLine(4, 3, 4, 5);
            cd.drawPoint(0, 5);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(54, cd -> {
            cd.drawLine(2, 0, 3, 0);
            cd.drawPoint(1, 1);
            cd.drawLine(0, 2, 0, 5);
            cd.drawLine(0, 3, 3, 3);
            cd.drawLine(4, 4, 4, 5);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(55, cd -> {
            cd.drawLine(0, 0, 0, 1);
            cd.drawLine(0, 0, 4, 0);
            cd.drawLine(4, 0, 4, 1);
            cd.drawPoint(3, 2);
            cd.drawLine(2, 3, 2, 6);
        });
        this.initChar(56, cd -> {
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(0, 1, 0, 2);
            cd.drawLine(4, 1, 4, 2);
            cd.drawLine(1, 3, 3, 3);
            cd.drawLine(4, 4, 4, 5);
            cd.drawLine(0, 4, 0, 5);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(57, cd -> {
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(0, 1, 0, 2);
            cd.drawLine(4, 1, 4, 5);
            cd.drawLine(1, 3, 3, 3);
            cd.drawLine(1, 6, 3, 6);
        });
    }

    private void initSpecialCharacters() {
        this.initChar(32, cd -> {});
        this.initChar(33, cd -> {
            cd.drawLine(2, 0, 2, 4);
            cd.drawLine(2, 6, 2, 6);
        });
        this.initChar(34, cd -> {
            cd.drawLine(0, 0, 0, 2);
            cd.drawLine(2, 0, 2, 2);
        });
        this.initChar(35, cd -> {
            cd.drawLine(1, 0, 1, 6);
            cd.drawLine(3, 0, 3, 6);
            cd.drawLine(0, 2, 4, 2);
            cd.drawLine(0, 4, 4, 4);
        });
        this.initChar(36, cd -> {
            cd.drawLine(1, 1, 4, 1);
            cd.drawLine(1, 3, 3, 3);
            cd.drawLine(0, 5, 3, 5);
            cd.drawLine(0, 2, 0, 2);
            cd.drawLine(4, 4, 4, 4);
            cd.drawLine(2, 0, 2, 6);
        });
        this.initChar(37, cd -> {
            cd.drawLine(0, 5, 0, 5);
            cd.drawLine(1, 4, 1, 4);
            cd.drawLine(2, 3, 2, 3);
            cd.drawLine(3, 2, 3, 2);
            cd.drawLine(4, 1, 4, 1);
            cd.drawRec(0, 0, 2, 2);
            cd.drawRec(3, 5, 2, 2);
        });
        this.initChar(38, cd -> {
            cd.drawLine(1, 0, 1, 0);
            cd.drawLine(0, 1, 0, 2);
            cd.drawLine(2, 1, 2, 2);
            cd.drawLine(1, 3, 1, 3);
            cd.drawLine(0, 4, 0, 5);
            cd.drawLine(2, 4, 2, 4);
            cd.drawLine(4, 4, 4, 4);
            cd.drawLine(3, 5, 3, 5);
            cd.drawLine(1, 6, 2, 6);
            cd.drawLine(4, 6, 4, 6);
        });
        this.initChar(39, cd -> {
            cd.drawLine(1, 0, 2, 0);
            cd.drawLine(2, 0, 2, 1);
            cd.drawLine(1, 2, 1, 2);
        });
        this.initChar(40, cd -> {
            cd.drawLine(3, 0, 3, 0);
            cd.drawLine(2, 1, 2, 1);
            cd.drawLine(1, 2, 1, 4);
            cd.drawLine(2, 5, 2, 5);
            cd.drawLine(3, 6, 3, 6);
        });
        this.initChar(41, cd -> {
            cd.drawLine(1, 0, 1, 0);
            cd.drawLine(2, 1, 2, 1);
            cd.drawLine(3, 2, 3, 4);
            cd.drawLine(2, 5, 2, 5);
            cd.drawLine(1, 6, 1, 6);
        });
        this.initChar(42, cd -> {
            cd.drawLine(0, 3, 4, 3);
            cd.drawLine(2, 1, 2, 5);
            cd.drawRec(1, 2, 3, 3);
            cd.drawLine(0, 1, 0, 1);
            cd.drawLine(4, 1, 4, 1);
            cd.drawLine(0, 5, 0, 5);
            cd.drawLine(4, 5, 4, 5);
        });
        this.initChar(43, cd -> {
            cd.drawLine(0, 3, 4, 3);
            cd.drawLine(2, 1, 2, 5);
        });
        this.initChar(44, cd -> {
            cd.drawLine(1, 5, 2, 5);
            cd.drawLine(2, 5, 2, 6);
            cd.drawLine(1, 7, 1, 7);
        });
        this.initChar(45, cd -> cd.drawLine(0, 3, 4, 3));
        this.initChar(46, cd -> cd.drawRec(1, 5, 2, 2));
        this.initChar(47, cd -> {
            cd.drawPoint(0, 6);
            cd.drawPoint(1, 5);
            cd.drawPoint(2, 4);
            cd.drawPoint(3, 3);
            cd.drawPoint(4, 2);
            cd.drawPoint(5, 1);
        });
        this.initChar(58, cd -> {
            cd.drawPoint(2, 2);
            cd.drawPoint(2, 5);
        });
        this.initChar(59, cd -> {
            cd.drawPoint(2, 2);
            cd.drawLine(2, 5, 2, 6);
            cd.drawPoint(1, 7);
        });
        this.initChar(60, cd -> {
            cd.drawPoint(4, 0);
            cd.drawPoint(3, 1);
            cd.drawPoint(2, 2);
            cd.drawPoint(1, 3);
            cd.drawPoint(2, 4);
            cd.drawPoint(3, 5);
            cd.drawPoint(4, 6);
        });
        this.initChar(61, cd -> {
            cd.drawLine(0, 2, 4, 2);
            cd.drawLine(0, 4, 4, 4);
        });
        this.initChar(62, cd -> {
            cd.drawPoint(0, 0);
            cd.drawPoint(1, 1);
            cd.drawPoint(2, 2);
            cd.drawPoint(3, 3);
            cd.drawPoint(2, 4);
            cd.drawPoint(1, 5);
            cd.drawPoint(0, 6);
        });
        this.initChar(63, cd -> {
            cd.drawLine(1, 0, 3, 0);
            cd.drawPoint(0, 1);
            cd.drawLine(4, 1, 4, 2);
            cd.drawPoint(3, 3);
            cd.drawPoint(2, 4);
            cd.drawPoint(2, 6);
        });
        this.initChar(64, cd -> {
            cd.drawLine(2, 0, 3, 0);
            cd.drawPoint(1, 1);
            cd.drawLine(4, 1, 4, 3);
            cd.drawLine(0, 2, 0, 4);
            cd.drawLine(3, 2, 4, 2);
            cd.drawPoint(2, 3);
            cd.drawPoint(3, 4);
            cd.drawPoint(1, 5);
            cd.drawLine(2, 6, 4, 6);
        });
        this.initChar(91, cd -> {
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(1, 0, 1, 6);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(92, cd -> {
            cd.drawPoint(5, 6);
            cd.drawPoint(4, 5);
            cd.drawPoint(3, 4);
            cd.drawPoint(2, 3);
            cd.drawPoint(1, 2);
            cd.drawPoint(0, 1);
        });
        this.initChar(93, cd -> {
            cd.drawLine(1, 0, 3, 0);
            cd.drawLine(3, 0, 3, 6);
            cd.drawLine(1, 6, 3, 6);
        });
        this.initChar(94, cd -> {
            cd.drawPoint(2, 0);
            cd.drawPoint(1, 1);
            cd.drawPoint(3, 1);
            cd.drawPoint(0, 2);
            cd.drawPoint(4, 2);
        });
        this.initChar(95, cd -> cd.drawLine(-1, 6, 5, 6));
        this.initChar(96, cd -> {
            cd.drawPoint(1, 0);
            cd.drawPoint(2, 1);
        });
        this.initChar(123, cd -> {
            cd.drawLine(3, 0, 4, 0);
            cd.drawLine(2, 1, 2, 2);
            cd.drawPoint(1, 3);
            cd.drawLine(2, 4, 2, 5);
            cd.drawLine(3, 6, 4, 6);
        });
        this.initChar(124, cd -> {
            cd.drawLine(2, 0, 2, 2);
            cd.drawLine(2, 4, 2, 6);
        });
        this.initChar(125, cd -> {
            cd.drawLine(0, 0, 1, 0);
            cd.drawLine(2, 1, 2, 2);
            cd.drawPoint(3, 3);
            cd.drawLine(2, 4, 2, 5);
            cd.drawLine(0, 6, 1, 6);
        });
        this.initChar(126, cd -> {
            cd.drawPoint(1, 0);
            cd.drawPoint(0, 1);
            cd.drawPoint(2, 1);
            cd.drawPoint(4, 1);
            cd.drawPoint(3, 2);
        });
        this.initChar(127, cd -> {});
    }

    private void initNewCharacters() {
        this.initChar(128, cd -> {
            cd.drawRec(2, 0, 2, 8);
            cd.drawRec(-1, 3, 8, 2);
        });
        this.initChar(129, cd -> {
            cd.drawRec(-1, 3, 8, 2);
            cd.drawRec(2, 3, 2, 5);
        });
        this.initChar(130, cd -> {
            cd.drawRec(2, 0, 2, 8);
            cd.drawRec(2, 3, 5, 2);
        });
        this.initChar(131, cd -> {
            cd.drawRec(2, 3, 5, 2);
            cd.drawRec(2, 3, 2, 5);
        });
        this.initChar(132, cd -> {
            cd.drawRec(2, 0, 2, 8);
            cd.drawRec(-1, 3, 5, 2);
        });
        this.initChar(133, cd -> {
            cd.drawRec(-1, 3, 5, 2);
            cd.drawRec(2, 3, 2, 5);
        });
        this.initChar(134, cd -> cd.drawRec(2, 0, 2, 8));
        this.initChar(135, cd -> {
            cd.drawRec(2, 0, 2, 5);
            cd.drawRec(-1, 3, 8, 2);
        });
        this.initChar(136, cd -> cd.drawRec(-1, 3, 8, 2));
        this.initChar(137, cd -> {
            cd.drawRec(2, 0, 2, 5);
            cd.drawRec(2, 3, 5, 2);
        });
        this.initChar(138, cd -> {
            cd.drawRec(2, 0, 2, 5);
            cd.drawRec(-1, 3, 5, 2);
        });
        this.initChar(139, cd -> {
            cd.drawLine(1, 0, 1, 2);
            cd.drawLine(4, 0, 4, 2);
            cd.drawLine(-1, 2, 1, 2);
            cd.drawLine(4, 2, 6, 2);
            cd.drawLine(-1, 5, 1, 5);
            cd.drawLine(4, 5, 6, 5);
            cd.drawLine(1, 5, 1, 7);
            cd.drawLine(4, 5, 4, 7);
        });
        this.initChar(140, cd -> {
            cd.drawLine(-1, 2, 6, 2);
            cd.drawLine(-1, 5, 1, 5);
            cd.drawLine(4, 5, 6, 5);
            cd.drawLine(1, 5, 1, 7);
            cd.drawLine(4, 5, 4, 7);
        });
        this.initChar(141, cd -> {
            cd.drawLine(1, 0, 1, 7);
            cd.drawLine(4, 0, 4, 2);
            cd.drawLine(4, 2, 6, 2);
            cd.drawLine(4, 5, 6, 5);
            cd.drawLine(4, 5, 4, 7);
        });
        this.initChar(142, cd -> {
            cd.drawLine(1, 2, 6, 2);
            cd.drawLine(4, 5, 6, 5);
            cd.drawLine(1, 2, 1, 7);
            cd.drawLine(4, 5, 4, 7);
        });
        this.initChar(143, cd -> {
            cd.drawLine(1, 0, 1, 2);
            cd.drawLine(4, 0, 4, 7);
            cd.drawLine(-1, 2, 1, 2);
            cd.drawLine(-1, 5, 1, 5);
            cd.drawLine(1, 5, 1, 7);
        });
        this.initChar(144, cd -> {
            cd.drawLine(-1, 2, 4, 2);
            cd.drawLine(-1, 5, 1, 5);
            cd.drawLine(1, 5, 1, 7);
            cd.drawLine(4, 2, 4, 7);
        });
        this.initChar(145, cd -> {
            cd.drawLine(1, 0, 1, 7);
            cd.drawLine(4, 0, 4, 7);
        });
        this.initChar(146, cd -> {
            cd.drawLine(1, 0, 1, 2);
            cd.drawLine(4, 0, 4, 2);
            cd.drawLine(-1, 2, 1, 2);
            cd.drawLine(4, 2, 6, 2);
            cd.drawLine(-1, 5, 6, 5);
        });
        this.initChar(147, cd -> {
            cd.drawLine(-1, 2, 6, 2);
            cd.drawLine(-1, 5, 6, 5);
        });
        this.initChar(148, cd -> {
            cd.drawLine(1, 0, 1, 5);
            cd.drawLine(4, 0, 4, 2);
            cd.drawLine(4, 2, 6, 2);
            cd.drawLine(1, 5, 6, 5);
        });
        this.initChar(149, cd -> {
            cd.drawLine(1, 0, 1, 2);
            cd.drawLine(4, 0, 4, 5);
            cd.drawLine(-1, 2, 1, 2);
            cd.drawLine(-1, 5, 4, 5);
        });
    }

    public CharacterDesign getDesign(char c) {
        if (c > '\u00ff') {
            return this.designs[0];
        }
        return this.designs[c];
    }
}

