/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.text;

import java.util.function.Consumer;
import javafx.scene.canvas.GraphicsContext;

public class CharacterDesign {
    private final GraphicsContext context;
    private final Consumer<CharacterDesign> painter;
    private double scale;
    private double x;
    private double y;

    protected CharacterDesign(GraphicsContext context, Consumer<CharacterDesign> painter) {
        this.context = context;
        this.painter = painter;
    }

    protected void paint(double x, double y, double scale) {
        this.x = x + scale;
        this.y = y;
        this.scale = scale;
        this.painter.accept(this);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        double offset = this.scale / 2.0;
        this.context.strokeLine(this.x + (double)x1 * this.scale + offset, this.y + (double)y1 * this.scale + offset, this.x + (double)x2 * this.scale + offset, this.y + (double)y2 * this.scale + offset);
    }

    public void drawPoint(int x, int y) {
        this.drawLine(x, y, x, y);
    }

    public void drawRec(int x1, int y1, int width, int height) {
        this.context.fillRect(this.x + (double)x1 * this.scale, this.y + (double)y1 * this.scale, (double)width * this.scale, (double)height * this.scale);
    }
}

