/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.code;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.hammerle.snuviscript.code.ExceptionBiFunction;
import me.hammerle.snuviscript.code.FunctionLoader;
import me.hammerle.snuviscript.code.ISnuviLogger;
import me.hammerle.snuviscript.code.ISnuviScheduler;
import me.hammerle.snuviscript.code.InputProvider;
import me.hammerle.snuviscript.code.Script;
import me.hammerle.snuviscript.code.SnuviUtils;
import me.hammerle.snuviscript.exceptions.PreScriptException;

public class SnuviParser {
    private final ISnuviLogger logger;
    private final ISnuviScheduler scheduler;
    private int idCounter;
    private final HashMap<Integer, Script> scripts;
    private final LinkedList<Integer> termQueue;

    public SnuviParser(ISnuviLogger logger, ISnuviScheduler scheduler) {
        this.logger = logger;
        this.scheduler = scheduler;
        this.scripts = new HashMap();
        this.termQueue = new LinkedList();
        this.idCounter = 0;
    }

    public ISnuviLogger getLogger() {
        return this.logger;
    }

    public ISnuviScheduler getScheduler() {
        return this.scheduler;
    }

    public void registerFunction(String s, ExceptionBiFunction<Script, InputProvider[], Object> f) {
        FunctionLoader.registerFunction(s, f);
    }

    public void registerAlias(String original, String alias) {
        FunctionLoader.registerAlias(original, alias);
    }

    public Script getScript(int id) {
        return this.scripts.get(id);
    }

    public boolean termUnsafe(Script sc) {
        if (sc == null) {
            return false;
        }
        sc.isValid = false;
        sc.onTerm();
        return this.scripts.remove(sc.id) != null;
    }

    public void termSafe(Script sc) {
        if (sc == null) {
            return;
        }
        sc.isHolded = true;
        sc.isWaiting = true;
        sc.isValid = false;
        this.termQueue.add(sc.id);
    }

    private void term() {
        if (!this.termQueue.isEmpty()) {
            this.termQueue.forEach(i -> {
                Script sc = this.scripts.remove(i);
                if (sc != null) {
                    sc.onTerm();
                }
            });
            this.termQueue.clear();
        }
    }

    public void termAllUnsafe() {
        this.scripts.values().forEach(sc -> {
            sc.onTerm();
            sc.isValid = false;
        });
        this.scripts.clear();
    }

    public Collection<Script> getScripts() {
        return this.scripts.values();
    }

    public Script startScript(boolean rEventBroadcast, Consumer<Script> onStart, Consumer<Script> onTerm, String end, String ... paths) {
        if (paths.length == 0) {
            return null;
        }
        try {
            List<String> code = SnuviUtils.readCode(end, paths);
            String simpleName = paths[0].substring(paths[0].lastIndexOf(47) + 1);
            Script sc = new Script(this, code, simpleName, paths[0], this.idCounter++, onStart, onTerm, rEventBroadcast);
            this.scripts.put(sc.id, sc);
            sc.onStart();
            sc.run();
            this.term();
            return sc;
        }
        catch (PreScriptException ex) {
            this.logger.print(ex.getLocalizedMessage(), ex, null, paths[0], null, ex.getEndLine() + 1);
            return null;
        }
    }

    public Script startScript(boolean rEventBroadcast, String end, String ... paths) {
        return this.startScript(rEventBroadcast, (Consumer<Script>)null, (Consumer<Script>)null, end, paths);
    }

    public void callEvent(String name, Consumer<Script> before, Consumer<Script> after, Predicate<Script> check) {
        this.scripts.values().stream().filter(sc -> sc.receiveEventBroadcast && !sc.isHolded && sc.isWaiting).filter(sc -> sc.isEventLoaded(name)).filter(check).forEach(sc -> {
            sc.setVar("event", name);
            if (before != null) {
                before.accept((Script)sc);
            }
            sc.run();
            if (after != null) {
                after.accept((Script)sc);
            }
        });
        this.term();
    }

    public void callEvent(String name, Consumer<Script> before, Consumer<Script> after) {
        this.callEvent(name, before, after, (Script sc) -> true);
    }

    public boolean callEvent(String name, Script sc, Consumer<Script> before, Consumer<Script> after, boolean check) {
        if (sc.isEventLoaded(name) && !sc.isHolded && sc.isWaiting && check) {
            sc.setVar("event", name);
            if (before != null) {
                before.accept(sc);
            }
            sc.run();
            if (after != null) {
                after.accept(sc);
            }
            this.term();
            return true;
        }
        return false;
    }

    public boolean callEvent(String name, Script sc, Consumer<Script> before, Consumer<Script> after) {
        return this.callEvent(name, sc, before, after, true);
    }
}

