/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import me.hammerle.snuviscript.code.Compiler;
import me.hammerle.snuviscript.code.ISnuviLogger;
import me.hammerle.snuviscript.code.ISnuviScheduler;
import me.hammerle.snuviscript.code.Instruction;
import me.hammerle.snuviscript.code.SnuviParser;
import me.hammerle.snuviscript.variable.LocalVariable;
import me.hammerle.snuviscript.variable.Variable;

public final class Script {
    protected final String simpleName;
    protected final String name;
    protected final int id;
    protected SnuviParser parser;
    protected ISnuviLogger logger;
    protected ISnuviScheduler scheduler;
    protected int currentLine;
    protected Instruction[] code;
    protected boolean isWaiting;
    protected boolean isHolded;
    protected boolean isValid;
    protected boolean receiveEventBroadcast;
    protected long cpuTime;
    protected int catchLine;
    protected String currentCommand;
    protected boolean ifState;
    private final HashMap<String, Integer> labels;
    protected final Stack<Integer> returnStack;
    protected HashMap<String, Variable> vars;
    protected final HashSet<String> events;
    protected final Stack<HashMap<String, Variable>> localVars;
    protected final HashMap<String, Integer> functions;
    protected final HashMap<String, HashMap<String, Integer>> localLabels;
    protected String currentFunction = null;
    protected Object returnValue;
    protected boolean printStackTrace;
    private final Consumer<Script> onStart;
    private final Consumer<Script> onTerm;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    public Script(SnuviParser parser, List<String> code, String simpleName, String name, int id, Consumer<Script> onStart, Consumer<Script> onTerm, boolean receiveEventBroadcast) {
        this.parser = parser;
        this.logger = parser.getLogger();
        this.scheduler = parser.getScheduler();
        this.labels = new HashMap();
        this.returnStack = new Stack();
        this.events = new HashSet();
        this.currentLine = 0;
        this.isWaiting = false;
        this.isHolded = false;
        this.isValid = true;
        this.receiveEventBroadcast = receiveEventBroadcast;
        this.cpuTime = 0L;
        this.catchLine = -1;
        this.currentCommand = null;
        this.ifState = true;
        this.printStackTrace = false;
        this.simpleName = simpleName;
        this.name = name;
        this.id = id;
        this.onStart = onStart;
        this.onTerm = onTerm;
        this.localVars = new Stack();
        this.functions = new HashMap();
        this.localLabels = new HashMap();
        this.code = Compiler.compile(this, code, this.labels, this.functions, this.localLabels);
    }

    public HashMap<String, Variable> getLocalVars() {
        return this.localVars.peek();
    }

    public Object run() {
        if (this.isHolded) {
            return this.returnValue;
        }
        int length = this.code.length;
        this.returnValue = null;
        this.isWaiting = false;
        this.cpuTime = 0L;
        while (this.currentLine < length && !this.isWaiting) {
            long time = System.nanoTime();
            try {
                this.code[this.currentLine].execute(this);
                ++this.currentLine;
            }
            catch (Exception ex) {
                if (this.printStackTrace) {
                    ex.printStackTrace();
                }
                if (this.catchLine != -1) {
                    this.currentLine = this.catchLine + 1;
                    this.catchLine = -1;
                    this.setVar("error", ex.getClass().getSimpleName());
                    continue;
                }
                int line = this.currentLine < length ? this.code[this.currentLine].getRealLine() + 1 : -1;
                this.logger.print(ex.getLocalizedMessage(), ex, this.currentCommand, this.name, this, line);
                return this.returnValue;
            }
            time = System.nanoTime() - time;
            this.cpuTime += time;
            if (this.cpuTime <= 15000000L) continue;
            this.isWaiting = true;
            this.isHolded = true;
            this.scheduler.scheduleTask(() -> {
                if (this.isValid) {
                    this.isHolded = false;
                    this.run();
                }
            }, 1L);
            return Void.TYPE;
        }
        if (this.currentLine >= length && !this.isWaiting && this.localVars.empty()) {
            this.parser.termSafe(this);
        }
        return this.returnValue;
    }

    public void end() {
        this.currentLine = this.code.length;
    }

    public int getActiveRealLine() {
        return this.code[this.currentLine].getRealLine();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public ISnuviLogger getLogger() {
        return this.logger;
    }

    public boolean isStackTracePrinted() {
        return this.printStackTrace;
    }

    public Variable getVar(String name) {
        if (!this.localVars.isEmpty()) {
            HashMap<String, Variable> map = this.localVars.peek();
            Variable var = map.get(name);
            if (var == null) {
                var = new LocalVariable(name);
                map.put(name, var);
            }
            return var;
        }
        HashMap<String, Variable> map = this.vars;
        Variable var = map.get(name);
        if (var == null) {
            var = new Variable(name);
            map.put(name, var);
        }
        return var;
    }

    public void setVar(String name, Object value) {
        if (!this.localVars.isEmpty()) {
            HashMap<String, Variable> map = this.localVars.peek();
            Variable var = map.get(name);
            if (var == null) {
                var = new LocalVariable(name);
                map.put(name, var);
            }
            var.set(this, value);
        } else {
            HashMap<String, Variable> map = this.vars;
            Variable var = map.get(name);
            if (var == null) {
                var = new Variable(name);
                map.put(name, var);
            }
            var.set(this, value);
        }
    }

    protected Integer getLabel(String name) {
        if (this.localVars.isEmpty()) {
            return this.labels.get(name);
        }
        return this.localLabels.get(this.currentFunction).get(name);
    }

    public boolean isEventLoaded(String s) {
        return this.events.contains(s);
    }

    public void onStart() {
        if (this.onStart != null) {
            this.onStart.accept(this);
        }
    }

    public synchronized void onTerm() {
        if (this.onTerm != null) {
            this.onTerm.accept(this);
        }
        this.closeables.forEach(c -> {
            this.logger.print("prepared statement not closed", null, null, this.name, this, -1);
            try {
                c.close();
            }
            catch (Exception ex) {
                this.logger.print("cannot close closeable in script", ex, null, this.name, this, -1);
            }
        });
    }

    public synchronized void addCloseable(AutoCloseable closeable) {
        this.closeables.add(closeable);
    }

    public synchronized void removeCloseable(AutoCloseable closeable) {
        this.closeables.remove(closeable);
    }
}

