/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.code;

import me.hammerle.snuviscript.code.Function;
import me.hammerle.snuviscript.code.InputProvider;
import me.hammerle.snuviscript.code.Script;

public class Instruction {
    private final int realLine;
    private final byte layer;
    private final InputProvider input;

    public Instruction(int realLine, byte layer, InputProvider input) {
        this.realLine = realLine;
        this.layer = layer;
        this.input = input;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getRealLine() {
        return this.realLine;
    }

    public InputProvider[] getArguments() {
        if (this.input instanceof Function) {
            return ((Function)this.input).getArguments();
        }
        return null;
    }

    public String toString() {
        int j;
        StringBuilder sb = new StringBuilder();
        sb.append(this.realLine);
        for (j = sb.length(); j < 10; ++j) {
            sb.insert(0, "0");
        }
        sb.append(" | ");
        for (j = 0; j < this.layer; ++j) {
            sb.append("    ");
        }
        sb.append(this.input);
        return sb.toString();
    }

    public void execute(Script sc) throws Exception {
        this.input.get(sc);
    }
}

