/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.code;

import me.hammerle.snuviscript.code.BasicFunction;
import me.hammerle.snuviscript.code.InputProvider;
import me.hammerle.snuviscript.code.Script;
import me.hammerle.snuviscript.variable.ArrayVariable;
import me.hammerle.snuviscript.variable.LocalArrayVariable;
import me.hammerle.snuviscript.variable.Variable;

public class Function
extends InputProvider {
    private final BasicFunction function;
    private final InputProvider[] input;

    public Function(BasicFunction function, InputProvider[] input) {
        this.function = function;
        this.input = input;
    }

    public InputProvider[] getArguments() {
        return this.input;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.function.getName());
        sb.append("(");
        for (InputProvider in : this.input) {
            sb.append(in);
            sb.append(", ");
        }
        if (this.input.length > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object get(Script sc) throws Exception {
        return this.function.execute(sc, this.input);
    }

    @Override
    public Object getArray(Script sc) throws Exception {
        Object o = this.function.execute(sc, this.input);
        if (o instanceof ArrayVariable || o instanceof LocalArrayVariable) {
            return o;
        }
        return null;
    }

    @Override
    public double getDouble(Script sc) throws Exception {
        return (Double)this.function.execute(sc, this.input);
    }

    @Override
    public String getString(Script sc) throws Exception {
        return String.valueOf(this.function.execute(sc, this.input));
    }

    @Override
    public boolean getBoolean(Script sc) throws Exception {
        return (Boolean)this.function.execute(sc, this.input);
    }

    @Override
    public Variable getVariable(Script sc) throws Exception {
        return (Variable)this.function.execute(sc, this.input);
    }
}

