/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviscript.code;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import me.hammerle.snuviscript.array.DynamicArray;
import me.hammerle.snuviscript.code.Function;
import me.hammerle.snuviscript.code.FunctionLoader;
import me.hammerle.snuviscript.code.InputProvider;
import me.hammerle.snuviscript.code.Instruction;
import me.hammerle.snuviscript.code.JumpData;
import me.hammerle.snuviscript.code.Script;
import me.hammerle.snuviscript.code.SignInverter;
import me.hammerle.snuviscript.code.SnuviUtils;
import me.hammerle.snuviscript.code.Syntax;
import me.hammerle.snuviscript.constants.ConstantBoolean;
import me.hammerle.snuviscript.constants.ConstantDouble;
import me.hammerle.snuviscript.constants.ConstantNull;
import me.hammerle.snuviscript.constants.ConstantString;
import me.hammerle.snuviscript.exceptions.PreScriptException;
import me.hammerle.snuviscript.variable.ArrayVariable;
import me.hammerle.snuviscript.variable.LocalArrayVariable;
import me.hammerle.snuviscript.variable.LocalVariable;
import me.hammerle.snuviscript.variable.Variable;

public class Compiler {
    private final List<String> sCode;
    private final HashMap<String, Variable> vars = new HashMap();
    private final HashMap<String, Integer> labels;
    private final HashMap<String, Variable> localVars = new HashMap();
    private final HashMap<String, Integer> functions;
    private final HashMap<String, HashMap<String, Integer>> localLabels;
    private String currentFunction = null;
    private final LinkedList<Instruction> code = new LinkedList();
    private int line = 0;
    private int layer = 0;
    private JumpData tryState = null;
    private final Stack<JumpWrapper> jumps = new Stack();
    private final Stack<JumpWrapper> loopJumps = new Stack();
    private final LinkedList<JumpData> breakContinueJumps = new LinkedList();
    private final HashMap<String, String> strings = new HashMap();
    private int stringCounter = 0;

    public static Instruction[] compile(Script sc, List<String> sCode, HashMap<String, Integer> labels, HashMap<String, Integer> functions, HashMap<String, HashMap<String, Integer>> localLabels) {
        Compiler compiler = new Compiler(sCode, labels, functions, localLabels);
        Instruction[] instructions = compiler.compile();
        sc.vars = compiler.vars;
        return instructions;
    }

    private Compiler(List<String> sCode, HashMap<String, Integer> labels, HashMap<String, Integer> functions, HashMap<String, HashMap<String, Integer>> localLabels) {
        this.sCode = sCode;
        this.labels = labels;
        this.functions = functions;
        this.localLabels = localLabels;
    }

    private void addCodeInstruction(String function, InputProvider[] input) {
        this.code.add(new Instruction(this.line + 1, (byte)this.layer, new Function(FunctionLoader.getFunction(function), input)));
    }

    private void addLabel(String name, int line) {
        HashMap<String, Integer> map;
        if (this.currentFunction != null ? (map = this.localLabels.get(this.currentFunction)).put(name, line) != null : this.labels.put(name, line) != null) {
            throw new PreScriptException("label duplicate", line);
        }
    }

    private Instruction[] compile() {
        int size = this.sCode.size();
        StringBuilder sb = new StringBuilder();
        int old = 0;
        boolean text = false;
        boolean comment = false;
        this.line = 0;
        while (this.line < size) {
            int labelIndex;
            int pos = sb.length();
            sb.append(this.sCode.get(this.line));
            while (pos < sb.length()) {
                if (comment) {
                    if (pos + 1 < sb.length() && sb.charAt(pos) == '*' && sb.charAt(pos + 1) == '/') {
                        comment = false;
                        sb.delete(old, pos + 2);
                    }
                    ++pos;
                    continue;
                }
                if (text) {
                    if (sb.charAt(pos) == '\"') {
                        String replacement = "#" + this.stringCounter++;
                        this.strings.put(replacement, sb.substring(old, pos + 1));
                        text = false;
                        sb.replace(old, pos + 1, replacement);
                        pos = old - 1 + replacement.length();
                    }
                    ++pos;
                    continue;
                }
                block0 : switch (sb.charAt(pos)) {
                    case '/': {
                        if (pos + 1 >= sb.length()) break;
                        switch (sb.charAt(pos + 1)) {
                            case '/': {
                                sb.delete(pos, sb.length());
                                break;
                            }
                            case '*': {
                                comment = true;
                                old = pos++;
                            }
                        }
                        break;
                    }
                    case '}': {
                        sb.delete(0, pos + 1);
                        pos = -1;
                        --this.layer;
                        if (this.jumps.isEmpty()) {
                            throw new PreScriptException("} without a corresponding function and / or {", this.line);
                        }
                        JumpWrapper data = this.jumps.pop();
                        switch (data.function) {
                            case "function": {
                                data.data.setRelativeJump(this.code.size() + 1);
                                this.currentFunction = null;
                                ++this.layer;
                                this.addCodeInstruction("return", new InputProvider[0]);
                                --this.layer;
                                break block0;
                            }
                            case "try": {
                                this.tryState = data.data;
                                break block0;
                            }
                            case "catch": {
                                data.data.setRelativeJump(this.code.size());
                                break block0;
                            }
                            case "else": 
                            case "elseif": 
                            case "if": {
                                data.data.setRelativeJump(this.code.size() + 1);
                                this.addCodeInstruction("endif", new InputProvider[0]);
                                break block0;
                            }
                            case "for": {
                                this.loopJumps.pop();
                                this.createBreakContinue(this.code.size());
                                JumpData jump = data.data;
                                jump.setRelativeJump(this.code.size());
                                this.addCodeInstruction("next", new InputProvider[]{new JumpData(-jump.getInt(null) - 1)});
                                break block0;
                            }
                            case "while": {
                                this.loopJumps.pop();
                                this.createBreakContinue(this.code.size());
                                JumpData jump = data.data;
                                jump.setRelativeJump(this.code.size() + 1);
                                this.addCodeInstruction("wend", new InputProvider[]{new JumpData(-jump.getInt(null) - 1)});
                                break block0;
                            }
                        }
                        break;
                    }
                    case '{': {
                        int currentJumps = this.jumps.size();
                        String check = sb.toString();
                        if (check.startsWith("function ")) {
                            if (this.currentFunction != null) {
                                throw new PreScriptException("function not allowed in another function", this.line);
                            }
                            int index = check.indexOf("(");
                            if (index == -1) {
                                throw new PreScriptException("missing function syntax", this.line);
                            }
                            this.currentFunction = check.substring(9, index).toLowerCase();
                            this.functions.put(this.currentFunction, this.code.size());
                            this.localLabels.put(this.currentFunction, new HashMap());
                            int endIndex = check.indexOf(")", index);
                            if (index == -1) {
                                throw new PreScriptException("missing function syntax", this.line);
                            }
                            String[] inputs = index + 1 == endIndex ? new String[]{} : check.substring(index + 1, endIndex).split("[ ]*,[ ]*");
                            InputProvider[] in = new InputProvider[inputs.length + 1];
                            for (int i = 1; i < in.length; ++i) {
                                in[i] = new ConstantString(inputs[i - 1]);
                            }
                            JumpData jump = new JumpData(this.code.size());
                            in[0] = jump;
                            this.jumps.add(new JumpWrapper(jump, "function"));
                            this.addCodeInstruction("function", in);
                            pos = endIndex + 1;
                            boolean b = true;
                            while (b) {
                                switch (sb.charAt(pos)) {
                                    case '{': {
                                        b = false;
                                        break;
                                    }
                                    case '\n': 
                                    case ' ': {
                                        break;
                                    }
                                    default: {
                                        throw new PreScriptException("invalid character between function and {", this.line);
                                    }
                                }
                                ++pos;
                            }
                            ++this.layer;
                            sb.delete(0, pos);
                        } else {
                            check = sb.substring(0, pos);
                            this.compileLine(check);
                            sb.delete(0, pos + 1);
                            ++this.layer;
                            if (currentJumps == this.jumps.size()) {
                                throw new PreScriptException("{ without a corresponding function", this.line);
                            }
                        }
                        pos = -1;
                        break;
                    }
                    case ';': {
                        this.compileLine(sb.substring(0, pos).trim());
                        sb.delete(0, pos + 1);
                        pos = -1;
                        break;
                    }
                    case '\"': {
                        text = true;
                        old = pos;
                    }
                }
                ++pos;
            }
            if (!text && !comment && (labelIndex = sb.indexOf("@")) != -1) {
                String label = sb.toString().trim();
                if (label.charAt(0) != '@') {
                    throw new PreScriptException("you seriously fucked up the syntax here", this.line);
                }
                this.addLabel(label.substring(1), this.code.size() - 1);
                sb = new StringBuilder();
            }
            ++this.line;
        }
        Instruction[] input = this.code.toArray(new Instruction[this.code.size()]);
        return input;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void compileLine(String currentCode) {
        String input;
        String[] parts;
        block83: {
            parts = SnuviUtils.split(this.strings, currentCode, this.line);
            if (this.tryState != null) {
                switch (parts.length) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        if (!parts[0].equals("catch")) {
                            throw new PreScriptException("no catch after try", this.line);
                        }
                        if (this.tryState == null) {
                            throw new PreScriptException("catch without try", this.line);
                        }
                        this.tryState.setRelativeJump(this.code.size());
                        JumpData jump = new JumpData(this.code.size());
                        this.addCodeInstruction("catch", new InputProvider[]{jump});
                        this.jumps.push(new JumpWrapper(jump, "catch"));
                        this.tryState = null;
                        return;
                    }
                }
                throw new PreScriptException("invalid catch after try", this.line);
            }
            if (parts.length == 0) {
                return;
            }
            if (parts[0].equals("return")) {
                this.addCodeInstruction("return", this.compileFunction(parts, true));
                return;
            }
            if (parts[0].startsWith("@")) {
                if (parts.length > 1) {
                    throw new PreScriptException("arguments after label", this.line);
                }
                this.addLabel(parts[0].substring(1), this.code.size() - 1);
                return;
            }
            if (parts.length == 1) {
                int bPos = parts[0].indexOf(40);
                if (bPos != -1) {
                    input = parts[0].substring(0, bPos);
                    parts = SnuviUtils.split(this.strings, parts[0].substring(bPos + 1, parts[0].length() - 1), this.line);
                    break block83;
                } else {
                    switch (parts[0]) {
                        case "try": {
                            JumpData jump = new JumpData(this.code.size());
                            this.addCodeInstruction("try", new InputProvider[]{jump});
                            this.jumps.push(new JumpWrapper(jump, "try"));
                            return;
                        }
                        case "else": {
                            JumpData jump = new JumpData(this.code.size());
                            this.addCodeInstruction("else", new InputProvider[]{jump});
                            this.jumps.push(new JumpWrapper(jump, "else"));
                            return;
                        }
                        case "while": {
                            throw new PreScriptException("missing syntax at while", this.line);
                        }
                        case "if": {
                            throw new PreScriptException("missing syntax at if", this.line);
                        }
                        case "elseif": {
                            throw new PreScriptException("missing syntax at elseif", this.line);
                        }
                        case "for": {
                            throw new PreScriptException("missing syntax at for", this.line);
                        }
                        case "break": {
                            if (this.loopJumps.isEmpty()) {
                                throw new PreScriptException("break without a loop", this.line);
                            }
                            JumpData jump = new JumpData(this.code.size() - 1);
                            this.breakContinueJumps.add(jump);
                            this.addCodeInstruction("break", new InputProvider[]{jump});
                            return;
                        }
                        case "continue": {
                            if (this.loopJumps.isEmpty()) {
                                throw new PreScriptException("continue without a loop", this.line);
                            }
                            JumpData jump = new JumpData(this.code.size());
                            this.breakContinueJumps.add(jump);
                            this.addCodeInstruction("continue", new InputProvider[]{jump});
                            return;
                        }
                    }
                    return;
                }
            }
            switch (parts[0]) {
                case "++": {
                    this.addCodeInstruction("p+", this.compileFunction(new String[]{parts[1]}, false));
                    return;
                }
                case "--": {
                    this.addCodeInstruction("p-", this.compileFunction(new String[]{parts[1]}, false));
                    return;
                }
            }
            switch (parts[1]) {
                case "++": 
                case "--": {
                    input = parts[1];
                    parts = new String[]{parts[0]};
                    break;
                }
                case "=": 
                case "+=": 
                case "-=": 
                case "*=": 
                case "/=": 
                case "%=": 
                case "<<=": 
                case ">>=": 
                case "&=": 
                case "^=": 
                case "|=": {
                    input = parts[1];
                    parts[1] = ",";
                    break;
                }
                default: {
                    throw new PreScriptException("unknown operation " + parts[1], this.line);
                }
            }
        }
        switch (input) {
            case "break": {
                throw new PreScriptException("break does not accept arguments", this.line);
            }
            case "continue": {
                throw new PreScriptException("continue does not accept arguments", this.line);
            }
        }
        switch (input) {
            case "elseif": {
                this.createIf("elseif", parts);
                return;
            }
            case "if": {
                this.createIf("if", parts);
                return;
            }
            case "for": {
                this.createFor(parts);
                return;
            }
            case "while": {
                this.createWhile(parts);
                return;
            }
        }
        this.addCodeInstruction(input, this.compileFunction(parts, false));
    }

    private void addSyntax(LinkedList<InputProvider> list, Syntax sy) {
        byte pars = sy.getParameters();
        if (pars > list.size()) {
            throw new PreScriptException("missing syntax argument", this.line);
        }
        if (sy == Syntax.UNARY_SUB) {
            list.add(new SignInverter(list.pollLast()));
            return;
        }
        InputProvider[] input = new InputProvider[pars];
        for (int j = input.length - 1; j >= 0; --j) {
            input[j] = list.pollLast();
        }
        list.add(new Function(FunctionLoader.getFunction(sy.getFunction()), input));
    }

    private void validateStackCounter(int stackCounter) {
        if (stackCounter < 0) {
            throw new PreScriptException("missing syntax argument", this.line);
        }
    }

    private InputProvider[] compileFunction(String[] parts, boolean first) {
        int bottom;
        LinkedList<InputProvider> list = new LinkedList<InputProvider>();
        int stackCounter = 0;
        Stack<Syntax> syntax = new Stack<Syntax>();
        for (int i = bottom = first ? 1 : 0; i < parts.length; ++i) {
            block15: {
                Syntax sy;
                block17: {
                    block16: {
                        if (parts[i].equals(",")) {
                            while (!syntax.isEmpty()) {
                                this.addSyntax(list, (Syntax)((Object)syntax.pop()));
                            }
                            stackCounter = 0;
                            continue;
                        }
                        sy = Syntax.getSyntax(parts[i]);
                        if (sy == Syntax.UNKNOWN) break block15;
                        if (stackCounter > 0) break block16;
                        switch (sy) {
                            case INVERT: {
                                break block17;
                            }
                            case BIT_INVERT: {
                                break block17;
                            }
                            case SUB: {
                                sy = Syntax.UNARY_SUB;
                                break block17;
                            }
                            case POST_INC: {
                                sy = Syntax.INC;
                                break block17;
                            }
                            case POST_DEC: {
                                sy = Syntax.DEC;
                                break block17;
                            }
                            default: {
                                throw new PreScriptException("missing syntax argument", this.line);
                            }
                        }
                    }
                    switch (sy) {
                        case INVERT: 
                        case BIT_INVERT: {
                            throw new PreScriptException("missing syntax argument", this.line);
                        }
                    }
                }
                int weight = sy.getWeight();
                while (!syntax.isEmpty() && ((Syntax)((Object)syntax.peek())).getWeight() <= weight) {
                    this.addSyntax(list, (Syntax)((Object)syntax.pop()));
                }
                this.validateStackCounter(stackCounter);
                syntax.add(sy);
                stackCounter -= sy.getParameters() - 1;
                continue;
            }
            ++stackCounter;
            list.add(this.convertString(parts[i]));
        }
        while (!syntax.isEmpty()) {
            this.addSyntax(list, (Syntax)((Object)syntax.pop()));
        }
        this.validateStackCounter(stackCounter);
        return list.toArray(new InputProvider[list.size()]);
    }

    private InputProvider convertString(String input) {
        if (input.startsWith("@")) {
            return new ConstantString(input.substring(1));
        }
        if (input.startsWith("\"") && input.endsWith("\"")) {
            return new ConstantString(input.substring(1, input.length() - 1));
        }
        if (input.equals("true")) {
            return ConstantBoolean.TRUE;
        }
        if (input.equals("false")) {
            return ConstantBoolean.FALSE;
        }
        if (input.equals("null")) {
            return ConstantNull.NULL;
        }
        if (SnuviUtils.isNumber(input)) {
            return new ConstantDouble(Double.parseDouble(input));
        }
        if (SnuviUtils.isFunction(input)) {
            int bPos = input.indexOf(40);
            String[] parts = SnuviUtils.split(this.strings, input.substring(bPos + 1, input.length() - 1), this.line);
            if (parts.length > 0) {
                return new Function(FunctionLoader.getFunction(input.substring(0, bPos)), this.compileFunction(parts, false));
            }
            return new Function(FunctionLoader.getFunction(input.substring(0, bPos)), new InputProvider[0]);
        }
        if (SnuviUtils.isArray(input)) {
            int bPos = input.indexOf(91);
            String[] parts = SnuviUtils.split(this.strings, input.substring(bPos + 1, input.length() - 1), this.line);
            if (parts.length > 0) {
                return this.createArray(input.substring(0, bPos), this.compileFunction(parts, false));
            }
            return this.createArray(input.substring(0, bPos), new InputProvider[0]);
        }
        return this.getOrCreateVariable(input);
    }

    public static Object convert(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).equals("true")) {
            return true;
        }
        if (input.equals("false")) {
            return false;
        }
        if (input.equals("null")) {
            return null;
        }
        if (input.startsWith("\"") && input.endsWith("\"")) {
            if (input.length() == 1) {
                return "\"";
            }
            return input.substring(1, input.length() - 1);
        }
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException ex) {
            return input;
        }
    }

    private Variable getOrCreateVariable(String var) {
        Variable oldVar;
        if (this.currentFunction != null && var.charAt(0) != '$') {
            Variable oldVar2 = this.localVars.get(var);
            if (oldVar2 == null) {
                oldVar2 = new LocalVariable(var);
                this.localVars.put(var, oldVar2);
            }
            return oldVar2;
        }
        if (var.charAt(0) == '$') {
            var = var.substring(1);
        }
        if ((oldVar = this.vars.get(var)) == null) {
            oldVar = new Variable(var);
            this.vars.put(var, oldVar);
        }
        return oldVar;
    }

    private DynamicArray createArray(String var, InputProvider[] in) {
        if (this.currentFunction != null) {
            Variable oldVar = this.localVars.get(var);
            if (oldVar == null) {
                oldVar = new LocalArrayVariable(var);
                this.localVars.put(var, oldVar);
            }
            return new DynamicArray(oldVar, in);
        }
        Variable oldVar = this.vars.get(var);
        if (oldVar == null) {
            oldVar = new ArrayVariable(var);
            this.vars.put(var, oldVar);
        }
        return new DynamicArray(oldVar, in);
    }

    private void createIf(String name, String[] parts) {
        InputProvider[] input = this.compileFunction(parts, false);
        InputProvider[] realInput = new InputProvider[input.length + 1];
        System.arraycopy(input, 0, realInput, 0, input.length);
        JumpData jump = new JumpData(this.code.size());
        realInput[input.length] = jump;
        this.jumps.push(new JumpWrapper(jump, name));
        this.addCodeInstruction(name, realInput);
    }

    private void createFor(String[] parts) {
        InputProvider[] input = this.compileFunction(parts, false);
        if (input.length != 3 && input.length != 4) {
            throw new PreScriptException("missing 'for' syntax at", this.line);
        }
        InputProvider[] realInput = new InputProvider[5];
        System.arraycopy(input, 0, realInput, 0, input.length);
        if (input.length == 3) {
            realInput[3] = new ConstantDouble(1.0);
        }
        JumpData jump = new JumpData(this.code.size());
        realInput[4] = jump;
        JumpWrapper wrapper = new JumpWrapper(jump, "for");
        this.jumps.push(wrapper);
        this.loopJumps.push(wrapper);
        this.addCodeInstruction("for", realInput);
    }

    private void createWhile(String[] parts) {
        InputProvider[] input = this.compileFunction(parts, false);
        if (input.length != 1) {
            throw new PreScriptException("invalid conditions at 'while'", this.line);
        }
        InputProvider[] realInput = new InputProvider[2];
        realInput[0] = input[0];
        JumpData jump = new JumpData(this.code.size());
        realInput[1] = jump;
        JumpWrapper wrapper = new JumpWrapper(jump, "while");
        this.jumps.push(wrapper);
        this.loopJumps.push(wrapper);
        this.addCodeInstruction("while", realInput);
    }

    private void createBreakContinue(int current) {
        this.breakContinueJumps.forEach(jump -> jump.setRelativeJump(current));
        this.breakContinueJumps.clear();
    }

    private class JumpWrapper {
        private final JumpData data;
        private final String function;

        public JumpWrapper(JumpData data, String function) {
            this.data = data;
            this.function = function;
        }
    }
}

