#version 430

uniform sampler2D samp;

uniform mat4 viewMatrix;
uniform mat4 modelMatrix;
uniform vec3 ambientLight;

struct Light 
{
    vec2 pos;
    float strength;
    vec3 color;
}; 

uniform Light lights[32];

uniform bool useTexture;
uniform bool useColor;
uniform bool useLight;
uniform bool useMixColor;
uniform vec4 mixColor;

in vec2 tc;
in vec2 loc;
in vec4 vColor;
out vec4 color;

vec4 getLight()
{
    vec3 light = vec3(0, 0, 0);
    for(int i = 0; i < 32; i++)
    {
        light += lights[i].color * max(1 - lights[i].strength * length(loc - lights[i].pos), 0);
    }
    return vec4(min(light, vec3(1, 1, 1)), 1);
}

void main(void)
{
    if(useTexture)
    {
        color = texture(samp, tc);
        if(color.a == 0.0)
        {
            discard;
        }
        if(useColor)
        {
            if(useMixColor)
            {
                color = (color + mixColor) * 0.5;
            }
            else
            {
                color = vColor;
            }
        }
    }
    else
    {
        color = vColor;
    }

    if(useLight)
    {
        color = pow(pow(color, vec4(1 / 2.2)) * vec4(ambientLight, 1.0) + getLight(), vec4(2.2));
    }
}