/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryAccess;
import org.lwjgl.system.MemoryManage;
import org.lwjgl.system.MemoryTextUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.jni.JNINativeInterface;

public final class MemoryUtil {
    public static final long NULL = 0L;
    private static final MemoryAccess.MemoryAccessor ACCESSOR;
    private static final MemoryTextUtil TEXT_UTIL;
    public static final int PAGE_SIZE;
    public static final int CACHE_LINE_SIZE;

    private MemoryUtil() {
    }

    public static MemoryAllocator getAllocator() {
        return LazyInit.ALLOCATOR_IMPL;
    }

    public static long nmemAlloc(long size) {
        return LazyInit.ALLOCATOR.malloc(size);
    }

    public static long nmemAllocChecked(long size) {
        long address;
        if (size == 0L) {
            address = 0L;
        } else {
            address = MemoryUtil.nmemAlloc(size);
            if (Checks.CHECKS && address == 0L) {
                throw new OutOfMemoryError();
            }
        }
        return address;
    }

    public static ByteBuffer memAlloc(int size) {
        return ACCESSOR.memByteBuffer(MemoryUtil.nmemAllocChecked(size), size);
    }

    private static long getAllocationSize(int elements, int elementShift) {
        long bytes = APIUtil.apiGetBytes(elements, elementShift);
        APIUtil.apiCheckAllocation(elements, bytes, Pointer.BITS64 ? Long.MAX_VALUE : 0xFFFFFFFFL);
        return bytes;
    }

    public static ShortBuffer memAllocShort(int size) {
        return ACCESSOR.memShortBuffer(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(size, 1)), size);
    }

    public static IntBuffer memAllocInt(int size) {
        return ACCESSOR.memIntBuffer(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(size, 2)), size);
    }

    public static FloatBuffer memAllocFloat(int size) {
        return ACCESSOR.memFloatBuffer(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(size, 2)), size);
    }

    public static LongBuffer memAllocLong(int size) {
        return ACCESSOR.memLongBuffer(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(size, 3)), size);
    }

    public static DoubleBuffer memAllocDouble(int size) {
        return ACCESSOR.memDoubleBuffer(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(size, 3)), size);
    }

    public static PointerBuffer memAllocPointer(int size) {
        return PointerBuffer.create(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(size, Pointer.POINTER_SHIFT)), size);
    }

    public static void nmemFree(long ptr) {
        LazyInit.ALLOCATOR.free(ptr);
    }

    public static void memFree(@Nullable Buffer ptr) {
        MemoryUtil.nmemFree(MemoryUtil.memAddress0Safe(ptr));
    }

    public static void memFree(@Nullable PointerBuffer ptr) {
        MemoryUtil.nmemFree(MemoryUtil.memAddress0Safe(ptr));
    }

    public static long nmemCalloc(long num, long size) {
        return LazyInit.ALLOCATOR.calloc(num, size);
    }

    public static long nmemCallocChecked(long num, long size) {
        long address;
        if (num == 0L || size == 0L) {
            address = 0L;
        } else {
            address = MemoryUtil.nmemCalloc(num, size);
            if (Checks.CHECKS && address == 0L) {
                throw new OutOfMemoryError();
            }
        }
        return address;
    }

    public static ByteBuffer memCalloc(int num, int size) {
        return ACCESSOR.memByteBuffer(MemoryUtil.nmemCallocChecked(num, size), num * size);
    }

    public static ByteBuffer memCalloc(int num) {
        return ACCESSOR.memByteBuffer(MemoryUtil.nmemCallocChecked(num, 1L), num);
    }

    public static ShortBuffer memCallocShort(int num) {
        return ACCESSOR.memShortBuffer(MemoryUtil.nmemCallocChecked(num, 2L), num);
    }

    public static IntBuffer memCallocInt(int num) {
        return ACCESSOR.memIntBuffer(MemoryUtil.nmemCallocChecked(num, 4L), num);
    }

    public static FloatBuffer memCallocFloat(int num) {
        return ACCESSOR.memFloatBuffer(MemoryUtil.nmemCallocChecked(num, 4L), num);
    }

    public static LongBuffer memCallocLong(int num) {
        return ACCESSOR.memLongBuffer(MemoryUtil.nmemCallocChecked(num, 8L), num);
    }

    public static DoubleBuffer memCallocDouble(int num) {
        return ACCESSOR.memDoubleBuffer(MemoryUtil.nmemCallocChecked(num, 8L), num);
    }

    public static PointerBuffer memCallocPointer(int num) {
        return PointerBuffer.create(MemoryUtil.nmemCallocChecked(num, Pointer.POINTER_SIZE), num);
    }

    public static long nmemRealloc(long ptr, long size) {
        return LazyInit.ALLOCATOR.realloc(ptr, size);
    }

    @Nullable
    private static <T extends Buffer> T realloc(@Nullable T old_p, @Nullable T new_p, int size) {
        if (old_p != null && new_p != null) {
            new_p.position(Math.min(old_p.position(), size));
        }
        return new_p;
    }

    @Nullable
    public static ByteBuffer memRealloc(@Nullable ByteBuffer ptr, int size) {
        return MemoryUtil.realloc(ptr, MemoryUtil.memByteBuffer(MemoryUtil.nmemRealloc(MemoryUtil.memAddress0Safe(ptr), size), size), size);
    }

    @Nullable
    public static ShortBuffer memRealloc(@Nullable ShortBuffer ptr, int size) {
        return MemoryUtil.realloc(ptr, MemoryUtil.memShortBuffer(MemoryUtil.nmemRealloc(MemoryUtil.memAddress0Safe(ptr), MemoryUtil.getAllocationSize(size, 1)), size), size);
    }

    @Nullable
    public static IntBuffer memRealloc(@Nullable IntBuffer ptr, int size) {
        return MemoryUtil.realloc(ptr, MemoryUtil.memIntBuffer(MemoryUtil.nmemRealloc(MemoryUtil.memAddress0Safe(ptr), MemoryUtil.getAllocationSize(size, 2)), size), size);
    }

    @Nullable
    public static LongBuffer memRealloc(@Nullable LongBuffer ptr, int size) {
        return MemoryUtil.realloc(ptr, MemoryUtil.memLongBuffer(MemoryUtil.nmemRealloc(MemoryUtil.memAddress0Safe(ptr), MemoryUtil.getAllocationSize(size, 3)), size), size);
    }

    @Nullable
    public static FloatBuffer memRealloc(@Nullable FloatBuffer ptr, int size) {
        return MemoryUtil.realloc(ptr, MemoryUtil.memFloatBuffer(MemoryUtil.nmemRealloc(MemoryUtil.memAddress0Safe(ptr), MemoryUtil.getAllocationSize(size, 2)), size), size);
    }

    @Nullable
    public static DoubleBuffer memRealloc(@Nullable DoubleBuffer ptr, int size) {
        return MemoryUtil.realloc(ptr, MemoryUtil.memDoubleBuffer(MemoryUtil.nmemRealloc(MemoryUtil.memAddress0Safe(ptr), MemoryUtil.getAllocationSize(size, 3)), size), size);
    }

    @Nullable
    public static PointerBuffer memRealloc(@Nullable PointerBuffer ptr, int size) {
        PointerBuffer buffer = MemoryUtil.memPointerBufferSafe(MemoryUtil.nmemRealloc(MemoryUtil.memAddress0Safe(ptr), MemoryUtil.getAllocationSize(size, Pointer.POINTER_SHIFT)), size);
        if (ptr != null && buffer != null) {
            buffer.position(Math.min(ptr.position(), size));
        }
        return buffer;
    }

    public static long nmemAlignedAlloc(long alignment, long size) {
        return LazyInit.ALLOCATOR.aligned_alloc(alignment, size);
    }

    public static long nmemAlignedAllocChecked(long alignment, long size) {
        long address;
        if (size == 0L) {
            address = 0L;
        } else {
            address = MemoryUtil.nmemAlignedAlloc(alignment, size);
            if (Checks.DEBUG && address == 0L) {
                throw new OutOfMemoryError();
            }
        }
        return address;
    }

    public static ByteBuffer memAlignedAlloc(int alignment, int size) {
        return ACCESSOR.memByteBuffer(MemoryUtil.nmemAlignedAllocChecked(alignment, size), size);
    }

    public static void nmemAlignedFree(long ptr) {
        LazyInit.ALLOCATOR.aligned_free(ptr);
    }

    public static void memAlignedFree(ByteBuffer ptr) {
        MemoryUtil.nmemAlignedFree(MemoryUtil.memAddress0Safe(ptr));
    }

    public static void memReport(MemoryAllocationReport report) {
        MemoryManage.DebugAllocator.report(report);
    }

    public static void memReport(MemoryAllocationReport report, MemoryAllocationReport.Aggregate groupByStackTrace, boolean groupByThread) {
        MemoryManage.DebugAllocator.report(report, groupByStackTrace, groupByThread);
    }

    public static long memAddress0(Buffer buffer) {
        return ACCESSOR.memAddress0(buffer);
    }

    public static long memAddress0Safe(@Nullable Buffer buffer) {
        return buffer == null ? 0L : ACCESSOR.memAddress0(buffer);
    }

    public static long memAddress0(CustomBuffer<?> buffer) {
        return buffer.address0();
    }

    public static long memAddress0Safe(@Nullable CustomBuffer<?> buffer) {
        return buffer == null ? 0L : buffer.address0();
    }

    public static long memAddress(ByteBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ByteBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)position;
    }

    private static long address(Buffer buffer, int position, int elementShift) {
        return MemoryUtil.memAddress0(buffer) + ((long)position << elementShift);
    }

    public static long memAddress(ShortBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ShortBuffer buffer, int position) {
        return MemoryUtil.address(buffer, position, 1);
    }

    public static long memAddress(CharBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(CharBuffer buffer, int position) {
        return MemoryUtil.address(buffer, position, 1);
    }

    public static long memAddress(IntBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(IntBuffer buffer, int position) {
        return MemoryUtil.address(buffer, position, 2);
    }

    public static long memAddress(FloatBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(FloatBuffer buffer, int position) {
        return MemoryUtil.address(buffer, position, 2);
    }

    public static long memAddress(LongBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(LongBuffer buffer, int position) {
        return MemoryUtil.address(buffer, position, 3);
    }

    public static long memAddress(DoubleBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(DoubleBuffer buffer, int position) {
        return MemoryUtil.address(buffer, position, 3);
    }

    public static long memAddress(CustomBuffer<?> buffer) {
        return buffer.address();
    }

    public static long memAddress(CustomBuffer<?> buffer, int position) {
        return buffer.address(position);
    }

    public static long memAddressSafe(@Nullable ByteBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(@Nullable ByteBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable ShortBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(@Nullable ShortBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable CharBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(@Nullable CharBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable IntBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(@Nullable IntBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable FloatBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(@Nullable FloatBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable LongBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(@Nullable LongBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable DoubleBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(@Nullable DoubleBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable CustomBuffer<?> buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(@Nullable Pointer pointer) {
        return pointer == null ? 0L : pointer.address();
    }

    private static long checkAlignment(long address, int mask) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        if (Checks.DEBUG && (address & (long)mask) != 0L) {
            throw new IllegalArgumentException("Unaligned memory address");
        }
        return address;
    }

    public static ByteBuffer memByteBuffer(long address, int capacity) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        return ACCESSOR.memByteBuffer(address, capacity);
    }

    @Nullable
    public static ByteBuffer memByteBufferSafe(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memByteBuffer(address, capacity);
    }

    public static ShortBuffer memShortBuffer(long address, int capacity) {
        return ACCESSOR.memShortBuffer(MemoryUtil.checkAlignment(address, 1), capacity);
    }

    @Nullable
    public static ShortBuffer memShortBufferSafe(long address, int capacity) {
        return address == 0L ? null : MemoryUtil.memShortBuffer(address, capacity);
    }

    public static CharBuffer memCharBuffer(long address, int capacity) {
        return ACCESSOR.memCharBuffer(MemoryUtil.checkAlignment(address, 1), capacity);
    }

    @Nullable
    public static CharBuffer memCharBufferSafe(long address, int capacity) {
        return address == 0L ? null : MemoryUtil.memCharBuffer(address, capacity);
    }

    public static IntBuffer memIntBuffer(long address, int capacity) {
        return ACCESSOR.memIntBuffer(MemoryUtil.checkAlignment(address, 3), capacity);
    }

    @Nullable
    public static IntBuffer memIntBufferSafe(long address, int capacity) {
        return address == 0L ? null : MemoryUtil.memIntBuffer(address, capacity);
    }

    public static LongBuffer memLongBuffer(long address, int capacity) {
        return ACCESSOR.memLongBuffer(MemoryUtil.checkAlignment(address, 7), capacity);
    }

    @Nullable
    public static LongBuffer memLongBufferSafe(long address, int capacity) {
        return address == 0L ? null : MemoryUtil.memLongBuffer(address, capacity);
    }

    public static FloatBuffer memFloatBuffer(long address, int capacity) {
        return ACCESSOR.memFloatBuffer(MemoryUtil.checkAlignment(address, 3), capacity);
    }

    @Nullable
    public static FloatBuffer memFloatBufferSafe(long address, int capacity) {
        return address == 0L ? null : MemoryUtil.memFloatBuffer(address, capacity);
    }

    public static DoubleBuffer memDoubleBuffer(long address, int capacity) {
        return ACCESSOR.memDoubleBuffer(MemoryUtil.checkAlignment(address, 7), capacity);
    }

    @Nullable
    public static DoubleBuffer memDoubleBufferSafe(long address, int capacity) {
        return address == 0L ? null : MemoryUtil.memDoubleBuffer(address, capacity);
    }

    public static PointerBuffer memPointerBuffer(long address, int capacity) {
        return PointerBuffer.create(MemoryUtil.checkAlignment(address, Pointer.POINTER_SIZE - 1), capacity);
    }

    @Nullable
    public static PointerBuffer memPointerBufferSafe(long address, int capacity) {
        return address == 0L ? null : MemoryUtil.memPointerBuffer(address, capacity);
    }

    public static ByteBuffer memSlice(ByteBuffer buffer) {
        return buffer.slice().order(buffer.order());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer memSlice(ByteBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            ByteBuffer byteBuffer = MemoryUtil.memSlice(buffer);
            return byteBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer memSlice(ShortBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            ShortBuffer shortBuffer = buffer.slice();
            return shortBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntBuffer memSlice(IntBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            IntBuffer intBuffer = buffer.slice();
            return intBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongBuffer memSlice(LongBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            LongBuffer longBuffer = buffer.slice();
            return longBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatBuffer memSlice(FloatBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            FloatBuffer floatBuffer = buffer.slice();
            return floatBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoubleBuffer memSlice(DoubleBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            DoubleBuffer doubleBuffer = buffer.slice();
            return doubleBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer memSlice(PointerBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            PointerBuffer pointerBuffer = (PointerBuffer)buffer.slice();
            return pointerBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    public static void memSet(ByteBuffer ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, ptr.remaining());
    }

    public static void memSet(ShortBuffer ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, APIUtil.apiGetBytes(ptr.remaining(), 1));
    }

    public static void memSet(CharBuffer ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, APIUtil.apiGetBytes(ptr.remaining(), 1));
    }

    public static void memSet(IntBuffer ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, APIUtil.apiGetBytes(ptr.remaining(), 2));
    }

    public static void memSet(LongBuffer ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, APIUtil.apiGetBytes(ptr.remaining(), 3));
    }

    public static void memSet(FloatBuffer ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, APIUtil.apiGetBytes(ptr.remaining(), 2));
    }

    public static void memSet(DoubleBuffer ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, APIUtil.apiGetBytes(ptr.remaining(), 3));
    }

    public static <T extends CustomBuffer<T>> void memSet(T ptr, int value) {
        MemoryUtil.memSet(MemoryUtil.memAddress(ptr), value, (long)ptr.remaining() * (long)ptr.sizeof());
    }

    public static void memCopy(ByteBuffer src, ByteBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining());
    }

    public static void memCopy(ShortBuffer src, ShortBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), APIUtil.apiGetBytes(src.remaining(), 1));
    }

    public static void memCopy(CharBuffer src, CharBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), APIUtil.apiGetBytes(src.remaining(), 1));
    }

    public static void memCopy(IntBuffer src, IntBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), APIUtil.apiGetBytes(src.remaining(), 2));
    }

    public static void memCopy(LongBuffer src, LongBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), APIUtil.apiGetBytes(src.remaining(), 3));
    }

    public static void memCopy(FloatBuffer src, FloatBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), APIUtil.apiGetBytes(src.remaining(), 2));
    }

    public static void memCopy(DoubleBuffer src, DoubleBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), APIUtil.apiGetBytes(src.remaining(), 3));
    }

    public static <T extends CustomBuffer<T>> void memCopy(T src, T dst) {
        if (Checks.CHECKS) {
            Checks.check(src, dst.remaining());
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), (long)src.remaining() * (long)src.sizeof());
    }

    public static void memSet(long ptr, int value, long bytes) {
        if (Checks.DEBUG && (ptr == 0L || bytes < 0L)) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memSet(ptr, value, bytes);
    }

    public static void memCopy(long src, long dst, long bytes) {
        if (Checks.DEBUG && (src == 0L || dst == 0L || bytes < 0L)) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memCopy(src, dst, bytes);
    }

    public static boolean memGetBoolean(long ptr) {
        return ACCESSOR.memGetByte(ptr) != 0;
    }

    public static byte memGetByte(long ptr) {
        return ACCESSOR.memGetByte(ptr);
    }

    public static short memGetShort(long ptr) {
        return ACCESSOR.memGetShort(ptr);
    }

    public static int memGetInt(long ptr) {
        return ACCESSOR.memGetInt(ptr);
    }

    public static long memGetLong(long ptr) {
        return ACCESSOR.memGetLong(ptr);
    }

    public static float memGetFloat(long ptr) {
        return ACCESSOR.memGetFloat(ptr);
    }

    public static double memGetDouble(long ptr) {
        return ACCESSOR.memGetDouble(ptr);
    }

    public static long memGetAddress(long ptr) {
        return ACCESSOR.memGetAddress(ptr);
    }

    public static void memPutByte(long ptr, byte value) {
        ACCESSOR.memPutByte(ptr, value);
    }

    public static void memPutShort(long ptr, short value) {
        ACCESSOR.memPutShort(ptr, value);
    }

    public static void memPutInt(long ptr, int value) {
        ACCESSOR.memPutInt(ptr, value);
    }

    public static void memPutLong(long ptr, long value) {
        ACCESSOR.memPutLong(ptr, value);
    }

    public static void memPutFloat(long ptr, float value) {
        ACCESSOR.memPutFloat(ptr, value);
    }

    public static void memPutDouble(long ptr, double value) {
        ACCESSOR.memPutDouble(ptr, value);
    }

    public static void memPutAddress(long ptr, long value) {
        ACCESSOR.memPutAddress(ptr, value);
    }

    public static native <T> T memGlobalRefToObject(long var0);

    @Deprecated
    public static long memNewGlobalRef(Object obj) {
        return JNINativeInterface.NewGlobalRef(obj);
    }

    @Deprecated
    public static void memDeleteGlobalRef(long globalRef) {
        JNINativeInterface.DeleteGlobalRef(globalRef);
    }

    @Deprecated
    public static long memNewWeakGlobalRef(Object obj) {
        return JNINativeInterface.NewWeakGlobalRef(obj);
    }

    @Deprecated
    public static void memDeleteWeakGlobalRef(long globalRef) {
        JNINativeInterface.DeleteWeakGlobalRef(globalRef);
    }

    public static ByteBuffer memASCII(CharSequence text) {
        return MemoryUtil.memASCII(text, true);
    }

    @Nullable
    public static ByteBuffer memASCIISafe(@Nullable CharSequence text) {
        return MemoryUtil.memASCIISafe(text, true);
    }

    public static ByteBuffer memASCII(CharSequence text, boolean nullTerminated) {
        ByteBuffer target = MemoryUtil.memAlloc(MemoryUtil.memLengthASCII(text, nullTerminated));
        MemoryUtil.memASCII(text, nullTerminated, target);
        return target;
    }

    @Nullable
    public static ByteBuffer memASCIISafe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? null : MemoryUtil.memASCII(text, nullTerminated);
    }

    public static int memASCII(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memASCII(text, nullTerminated, target, target.position());
    }

    public static int memASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        return TEXT_UTIL.encodeASCII(text, nullTerminated, target, offset);
    }

    public static int memLengthASCII(CharSequence value, boolean nullTerminated) {
        return value.length() + (nullTerminated ? 1 : 0);
    }

    public static ByteBuffer memUTF8(CharSequence text) {
        return MemoryUtil.memUTF8(text, true);
    }

    @Nullable
    public static ByteBuffer memUTF8Safe(@Nullable CharSequence text) {
        return MemoryUtil.memUTF8Safe(text, true);
    }

    public static ByteBuffer memUTF8(CharSequence text, boolean nullTerminated) {
        ByteBuffer target = MemoryUtil.memAlloc(MemoryUtil.memLengthUTF8(text, nullTerminated));
        MemoryUtil.memUTF8(text, nullTerminated, target);
        return target;
    }

    @Nullable
    public static ByteBuffer memUTF8Safe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? null : MemoryUtil.memUTF8(text, nullTerminated);
    }

    public static int memUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memUTF8(text, nullTerminated, target, target.position());
    }

    public static int memUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        return TEXT_UTIL.encodeUTF8(text, nullTerminated, target, offset);
    }

    public static int memLengthUTF8(CharSequence value, boolean nullTerminated) {
        return MemoryTextUtil.encodeUTF8Length(value) + (nullTerminated ? 1 : 0);
    }

    public static ByteBuffer memUTF16(CharSequence text) {
        return MemoryUtil.memUTF16(text, true);
    }

    @Nullable
    public static ByteBuffer memUTF16Safe(@Nullable CharSequence text) {
        return MemoryUtil.memUTF16Safe(text, true);
    }

    public static ByteBuffer memUTF16(CharSequence text, boolean nullTerminated) {
        ByteBuffer target = MemoryUtil.memAlloc(MemoryUtil.memLengthUTF16(text, nullTerminated));
        MemoryUtil.memUTF16(text, nullTerminated, target);
        return target;
    }

    @Nullable
    public static ByteBuffer memUTF16Safe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? null : MemoryUtil.memUTF16(text, nullTerminated);
    }

    public static int memUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memUTF16(text, nullTerminated, target, target.position());
    }

    public static int memUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        return TEXT_UTIL.encodeUTF16(text, nullTerminated, target, offset);
    }

    public static int memLengthUTF16(CharSequence value, boolean nullTerminated) {
        return value.length() + (nullTerminated ? 1 : 0) << 1;
    }

    private static int memLengthNT1(long address, int maxLength) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        return Pointer.BITS64 ? TEXT_UTIL.strlen64NT1(address, maxLength) : TEXT_UTIL.strlen32NT1(address, maxLength);
    }

    public static int memLengthNT1(ByteBuffer buffer) {
        return MemoryUtil.memLengthNT1(MemoryUtil.memAddress(buffer), buffer.remaining());
    }

    private static int memLengthNT2(long address, int maxLength) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        return Pointer.BITS64 ? TEXT_UTIL.strlen64NT2(address, maxLength) : TEXT_UTIL.strlen32NT2(address, maxLength);
    }

    public static int memLengthNT2(ByteBuffer buffer) {
        return MemoryUtil.memLengthNT2(MemoryUtil.memAddress(buffer), buffer.remaining());
    }

    public static ByteBuffer memByteBufferNT1(long address) {
        return MemoryUtil.memByteBufferNT1(address, Integer.MAX_VALUE);
    }

    public static ByteBuffer memByteBufferNT1(long address, int maxLength) {
        return MemoryUtil.memByteBuffer(address, MemoryUtil.memLengthNT1(address, maxLength));
    }

    @Nullable
    public static ByteBuffer memByteBufferNT1Safe(long address) {
        return MemoryUtil.memByteBufferNT1Safe(address, Integer.MAX_VALUE);
    }

    @Nullable
    public static ByteBuffer memByteBufferNT1Safe(long address, int maxLength) {
        return address == 0L ? null : MemoryUtil.memByteBufferNT1(address, maxLength);
    }

    public static ByteBuffer memByteBufferNT2(long address) {
        return MemoryUtil.memByteBufferNT2(address, 0x7FFFFFFE);
    }

    public static ByteBuffer memByteBufferNT2(long address, int maxLength) {
        if (Checks.DEBUG) {
            if ((address & 1L) != 0L) {
                throw new IllegalArgumentException("The string address is not aligned.");
            }
            if ((maxLength & 1) != 0) {
                throw new IllegalArgumentException("The maximum length must be an even number.");
            }
        }
        return MemoryUtil.memByteBuffer(address, MemoryUtil.memLengthNT2(address, maxLength));
    }

    @Nullable
    public static ByteBuffer memByteBufferNT2Safe(long address) {
        return MemoryUtil.memByteBufferNT2Safe(address, 0x7FFFFFFE);
    }

    @Nullable
    public static ByteBuffer memByteBufferNT2Safe(long address, int maxLength) {
        return address == 0L ? null : MemoryUtil.memByteBufferNT2(address, maxLength);
    }

    public static String memASCII(long address) {
        ByteBuffer buffer = MemoryUtil.memByteBufferNT1(address);
        return MemoryUtil.memASCII(buffer, buffer.remaining(), 0);
    }

    public static String memASCII(ByteBuffer buffer) {
        return MemoryUtil.memASCII(buffer, buffer.remaining());
    }

    @Nullable
    public static String memASCIISafe(long address) {
        return address == 0L ? null : MemoryUtil.memASCII(address);
    }

    @Nullable
    public static String memASCIISafe(@Nullable ByteBuffer buffer) {
        return buffer == null ? null : MemoryUtil.memASCII(buffer);
    }

    public static String memASCII(ByteBuffer buffer, int length) {
        return MemoryTextUtil.decodeASCII(buffer, length, buffer.position());
    }

    public static String memASCII(ByteBuffer buffer, int length, int offset) {
        Objects.requireNonNull(buffer);
        return MemoryTextUtil.decodeASCII(buffer, length, offset);
    }

    public static String memUTF8(long address) {
        ByteBuffer buffer = MemoryUtil.memByteBufferNT1(address);
        return MemoryUtil.memUTF8(buffer, buffer.remaining(), 0);
    }

    public static String memUTF8(ByteBuffer buffer) {
        return MemoryUtil.memUTF8(buffer, buffer.remaining());
    }

    @Nullable
    public static String memUTF8Safe(long address) {
        return address == 0L ? null : MemoryUtil.memUTF8(address);
    }

    @Nullable
    public static String memUTF8Safe(@Nullable ByteBuffer buffer) {
        return buffer == null ? null : MemoryUtil.memUTF8(buffer);
    }

    public static String memUTF8(ByteBuffer buffer, int length) {
        return MemoryTextUtil.decodeUTF8(buffer, length, buffer.position());
    }

    public static String memUTF8(ByteBuffer buffer, int length, int offset) {
        Objects.requireNonNull(buffer);
        return MemoryTextUtil.decodeUTF8(buffer, length, offset);
    }

    public static String memUTF16(long address) {
        return MemoryUtil.memUTF16(MemoryUtil.memByteBufferNT2(address));
    }

    public static String memUTF16(ByteBuffer buffer) {
        return MemoryUtil.memUTF16(buffer, buffer.remaining() >> 1);
    }

    @Nullable
    public static String memUTF16Safe(long address) {
        return address == 0L ? null : MemoryUtil.memUTF16(address);
    }

    @Nullable
    public static String memUTF16Safe(@Nullable ByteBuffer buffer) {
        return buffer == null ? null : MemoryUtil.memUTF16(buffer);
    }

    public static String memUTF16(ByteBuffer buffer, int length) {
        return MemoryTextUtil.decodeUTF16(buffer, length, buffer.position());
    }

    public static String memUTF16(ByteBuffer buffer, int length, int offset) {
        Objects.requireNonNull(buffer);
        return MemoryTextUtil.decodeUTF16(buffer, length, offset);
    }

    static {
        Library.initialize();
        ACCESSOR = MemoryAccess.getInstance();
        TEXT_UTIL = ACCESSOR.getTextUtil();
        PAGE_SIZE = ACCESSOR.getPageSize();
        CACHE_LINE_SIZE = ACCESSOR.getCacheLineSize();
        APIUtil.apiLog("MemoryUtil accessor: " + ACCESSOR.getClass().getSimpleName());
    }

    public static interface MemoryAllocationReport {
        public void invoke(long var1, long var3, @Nullable String var5, StackTraceElement ... var6);

        public static enum Aggregate {
            ALL,
            GROUP_BY_METHOD,
            GROUP_BY_STACKTRACE;

        }
    }

    public static interface MemoryAllocator {
        public long getMalloc();

        public long getCalloc();

        public long getRealloc();

        public long getFree();

        public long getAlignedAlloc();

        public long getAlignedFree();

        public long malloc(long var1);

        public long calloc(long var1, long var3);

        public long realloc(long var1, long var3);

        public void free(long var1);

        public long aligned_alloc(long var1, long var3);

        public void aligned_free(long var1);
    }

    static final class LazyInit {
        static final MemoryAllocator ALLOCATOR_IMPL = MemoryManage.getInstance();
        static final MemoryAllocator ALLOCATOR = Configuration.DEBUG_MEMORY_ALLOCATOR.get(false) != false ? new MemoryManage.DebugAllocator(ALLOCATOR_IMPL) : ALLOCATOR_IMPL;

        private LazyInit() {
        }

        static {
            APIUtil.apiLog("MemoryUtil allocator: " + ALLOCATOR.getClass().getSimpleName());
        }
    }
}

