/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.game;

import java.util.List;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.game.BoxList;
import me.hammerle.snuviengine.game.Game;
import me.hammerle.snuviengine.game.Hero;
import me.hammerle.snuviengine.game.IBoxListEntry;
import me.hammerle.snuviengine.util.Face;

public class Entity
implements IBoxListEntry {
    private static final double STEP = 0.0625;
    public Game game;
    public double lastXPos;
    public double lastYPos;
    public double xPos;
    public double yPos;
    public double width;
    public double height;
    public double vx = 0.0;
    public double vy = 0.0;
    public BoxList.Node node;
    public int counter = 0;

    public Entity(Game game, double width, double height) {
        this.game = game;
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.width = width;
        this.height = height;
        this.vx = 1.0;
        this.vy = 1.0;
    }

    private boolean isColliding(Entity ent) {
        return this.xPos + this.width > ent.xPos && ent.xPos + ent.width > this.xPos && this.yPos + this.height > ent.yPos && ent.yPos + ent.height > this.yPos;
    }

    @Override
    public boolean isColliding(double minX, double minY, double maxX, double maxY) {
        return this.xPos + this.width > minX && maxX > this.xPos && this.yPos + this.height > minY && maxY > this.yPos;
    }

    public void tick() {
        if (!(this instanceof Hero)) {
            if (this.xPos < 0.0625) {
                this.vx = Math.abs(this.vx);
            }
            if (this.xPos + this.width > 399.9375) {
                this.vx = -Math.abs(this.vx);
            }
            if (this.yPos < 0.0625) {
                this.vy = Math.abs(this.vx);
            }
            if (this.yPos + this.height > 299.9375) {
                this.vy = -Math.abs(this.vx);
            }
        }
        this.lastXPos = this.xPos;
        this.lastYPos = this.yPos;
        if (this.vx == 0.0 && this.vy == 0.0) {
            return;
        }
        double lvx = this.vx;
        double lvy = this.vy;
        List<Entity> list = this.game.entities.getAllEntitiesAt(this, this.xPos - 0.0625 + (this.vx < 0.0 ? this.vx : 0.0), this.yPos - 0.0625 + (this.vy < 0.0 ? this.vy : 0.0), this.xPos + 0.0625 + this.width + (this.vx > 0.0 ? this.vx : 0.0), this.yPos + 0.0625 + this.height + (this.vy > 0.0 ? this.vy : 0.0));
        if (list.isEmpty()) {
            this.xPos += this.vx;
            this.yPos += this.vy;
            this.game.entities.update(this);
            return;
        }
        block0: while (lvx != 0.0 || lvy != 0.0) {
            double oldXPos = this.xPos;
            double oldYPos = this.yPos;
            if (lvx < 0.0) {
                if (lvx > -0.0625) {
                    this.xPos += lvx;
                    lvx = 0.0;
                } else {
                    this.xPos -= 0.0625;
                    lvx += 0.0625;
                }
            } else if (lvx > 0.0) {
                if (lvx < 0.0625) {
                    this.xPos += lvx;
                    lvx = 0.0;
                } else {
                    this.xPos += 0.0625;
                    lvx -= 0.0625;
                }
            }
            for (Entity ent2 : list) {
                if (!this.isColliding(ent2)) continue;
                lvx = 0.0;
                this.xPos = oldXPos;
                break;
            }
            if (lvy < 0.0) {
                if (lvy > -0.0625) {
                    this.yPos += lvy;
                    lvy = 0.0;
                } else {
                    this.yPos -= 0.0625;
                    lvy += 0.0625;
                }
            } else if (lvy > 0.0) {
                if (lvy < 0.0625) {
                    this.yPos += lvy;
                    lvy = 0.0;
                } else {
                    this.yPos += 0.0625;
                    lvy -= 0.0625;
                }
            }
            for (Entity ent2 : list) {
                if (!this.isColliding(ent2)) continue;
                lvy = 0.0;
                this.yPos = oldYPos;
                continue block0;
            }
        }
        this.game.entities.update(this);
        for (Face f : Face.values()) {
            double minX = this.xPos + 0.0625 * (double)f.getOffsetX();
            double minY = this.yPos + 0.0625 * (double)f.getOffsetY();
            double maxX = minX + this.width;
            double maxY = minY + this.height;
            list.stream().filter(ent -> ent.isColliding(minX, minY, maxX, maxY)).forEach(ent -> this.onCollide(f, (Entity)ent));
        }
    }

    public void onCollide(Face f, Entity ent) {
        switch (f) {
            case UP: {
                this.vy = Math.abs(this.vy);
                break;
            }
            case DOWN: {
                this.vy = -Math.abs(this.vy);
                break;
            }
            case LEFT: {
                this.vx = Math.abs(this.vx);
                break;
            }
            case RIGHT: {
                this.vx = -Math.abs(this.vx);
            }
        }
    }

    public void renderTick(float lag) {
        Shader.getColorRenderer().setDepth((float)this.yPos);
        float x = (float)(this.lastXPos + (this.xPos - this.lastXPos) * (double)lag);
        float y = (float)(this.lastYPos + (this.yPos - this.lastYPos) * (double)lag);
        Shader.getColorRenderer().drawRectangle(x, y, (float)((double)x + this.width), (float)((double)y + this.height), 0x770000FF);
    }

    public double getX() {
        return this.xPos;
    }

    public double getY() {
        return this.yPos;
    }

    public void setPosition(double x, double y) {
        this.xPos = x;
        this.yPos = y;
    }

    @Override
    public double getCenterX() {
        return this.xPos + this.width / 2.0;
    }

    @Override
    public double getCenterY() {
        return this.yPos + this.height / 2.0;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public BoxList.Node getNode() {
        return this.node;
    }
}

