/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.nio.ByteBuffer;
import me.hammerle.snuviengine.api.GLHelper;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.api.Texture;
import me.hammerle.snuviengine.util.Color;
import me.hammerle.snuviengine.util.Rectangle;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class FontRenderer {
    private static final float ERROR = 0.0f;
    private static final Texture[] FONT_TEXTURE = new Texture[]{new Texture("font8x8.png", true), new Texture("font16x16.png", true), new Texture("font24x24.png", true)};
    public static final char COLOR_CHAR = '&';
    private static final float[] COLORS = new float[128];
    private static final float[] DARK_COLORS = new float[128];
    private static final int FONT_SIZE = 8;
    private static final int LINE_STEP = 1;
    private static final float SHADOW_STEP = 1.0f;
    private int vao;
    private int vbo;
    private float color;
    private ByteBuffer buffer = BufferUtils.createByteBuffer((int)61440);
    private static final int MAX_LENGTH = 256;
    private static final int BUFFER_BYTE_LENGTH = 0x100000;
    private static final int OBJECT_LENGTH = 61440;
    private int offset = 987136;

    protected FontRenderer() {
        Shader.addTask(() -> {
            this.vao = GL30.glGenVertexArrays();
            this.vbo = GL15.glGenBuffers();
            GLHelper.glBindVertexArray(this.vao);
            GLHelper.glBindBuffer(this.vbo);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)20, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)8L);
            GL20.glVertexAttribPointer((int)2, (int)4, (int)5121, (boolean)true, (int)20, (long)16L);
        });
    }

    private void addRectangle(float minX, float minY, char c) {
        float scale = Shader.getViewScale();
        minY = (float)Math.round(minY * scale) / scale;
        minX = (float)Math.round(minX * scale) / scale;
        float tMinX = (float)(c & 0xF) / 16.0f;
        float tMinY = (float)(c >> 4) / 16.0f;
        float tMaxX = tMinX + 0.0625f;
        float tMaxY = tMinY + 0.0625f;
        float maxX = minX + 8.0f;
        float maxY = minY + 8.0f;
        this.buffer.putFloat(minX);
        this.buffer.putFloat(maxY);
        this.buffer.putFloat(tMinX);
        this.buffer.putFloat(tMaxY);
        this.buffer.putFloat(this.color);
        this.buffer.putFloat(minX);
        this.buffer.putFloat(minY);
        this.buffer.putFloat(tMinX);
        this.buffer.putFloat(tMinY);
        this.buffer.putFloat(this.color);
        this.buffer.putFloat(maxX);
        this.buffer.putFloat(maxY);
        this.buffer.putFloat(tMaxX);
        this.buffer.putFloat(tMaxY);
        this.buffer.putFloat(this.color);
        this.buffer.putFloat(maxX);
        this.buffer.putFloat(maxY);
        this.buffer.putFloat(tMaxX);
        this.buffer.putFloat(tMaxY);
        this.buffer.putFloat(this.color);
        this.buffer.putFloat(minX);
        this.buffer.putFloat(minY);
        this.buffer.putFloat(tMinX);
        this.buffer.putFloat(tMinY);
        this.buffer.putFloat(this.color);
        this.buffer.putFloat(maxX);
        this.buffer.putFloat(minY);
        this.buffer.putFloat(tMaxX);
        this.buffer.putFloat(tMinY);
        this.buffer.putFloat(this.color);
    }

    public float drawString(float x, float y, boolean shadow, String s) {
        GLHelper.glBindBuffer(this.vbo);
        this.offset += 61440;
        if (this.offset + 61440 >= 0x100000) {
            this.offset = 0;
            GL15.glBufferData((int)34962, (long)0x100000L, (int)35040);
        }
        this.buffer = GL30.glMapBufferRange((int)34962, (long)this.offset, (long)61440L, (int)34, (ByteBuffer)this.buffer);
        if (this.buffer == null) {
            return y;
        }
        if (shadow) {
            this.addString(x + 1.0f, y + 1.0f, DARK_COLORS, s);
        }
        y = this.addString(x, y, COLORS, s);
        this.buffer.flip();
        GL15.glUnmapBuffer((int)34962);
        GLHelper.glBindVertexArray(this.vao);
        FONT_TEXTURE[Math.min(Shader.getViewScale() - 1, FONT_TEXTURE.length - 1)].bind();
        GL11.glDrawArrays((int)4, (int)(this.offset / 20), (int)(this.buffer.limit() / 20));
        this.buffer.limit(this.buffer.capacity());
        return y;
    }

    public float drawString(float x, float y, String s) {
        return this.drawString(x, y, true, s);
    }

    private float addString(float x, float y, float[] colors, String s) {
        int l = Math.min(s.length(), 256);
        float oldX = x;
        this.color = colors[102];
        for (int pos = 0; pos < l; ++pos) {
            char c = s.charAt(pos);
            if (c == '&') {
                char index;
                if (++pos >= l || (index = s.charAt(pos)) < '\u0000' || index > colors.length) continue;
                this.color = colors[s.charAt(pos)];
                continue;
            }
            if (c == '\n') {
                y += 9.0f;
                x = oldX;
                continue;
            }
            this.addRectangle(x, y, c);
            x += 8.0f;
        }
        return y + 8.0f + 1.0f;
    }

    public Rectangle getSize(String s) {
        int length = 0;
        int counter = 1;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\n': {
                    ++counter;
                    continue block4;
                }
                case '&': {
                    ++i;
                    continue block4;
                }
                default: {
                    ++length;
                }
            }
        }
        return new Rectangle(8 * length, 9 * counter);
    }

    public Rectangle getSize(int w, int h) {
        return new Rectangle(8 * w, 9 * h);
    }

    public float getHeight() {
        return 9.0f;
    }

    public float getWidth() {
        return 8.0f;
    }

    static {
        FontRenderer.COLORS[48] = Float.intBitsToFloat(Color.get(0, 0, 0));
        FontRenderer.COLORS[49] = Float.intBitsToFloat(Color.get(0, 0, 170));
        FontRenderer.COLORS[50] = Float.intBitsToFloat(Color.get(0, 170, 0));
        FontRenderer.COLORS[51] = Float.intBitsToFloat(Color.get(0, 170, 170));
        FontRenderer.COLORS[52] = Float.intBitsToFloat(Color.get(170, 0, 0));
        FontRenderer.COLORS[53] = Float.intBitsToFloat(Color.get(170, 0, 170));
        FontRenderer.COLORS[54] = Float.intBitsToFloat(Color.get(255, 170, 0));
        FontRenderer.COLORS[55] = Float.intBitsToFloat(Color.get(170, 170, 170));
        FontRenderer.COLORS[56] = Float.intBitsToFloat(Color.get(85, 85, 85));
        FontRenderer.COLORS[57] = Float.intBitsToFloat(Color.get(85, 85, 255));
        FontRenderer.COLORS[97] = Float.intBitsToFloat(Color.get(85, 255, 85));
        FontRenderer.COLORS[98] = Float.intBitsToFloat(Color.get(85, 255, 255));
        FontRenderer.COLORS[99] = Float.intBitsToFloat(Color.get(255, 85, 85));
        FontRenderer.COLORS[100] = Float.intBitsToFloat(Color.get(255, 85, 255));
        FontRenderer.COLORS[101] = Float.intBitsToFloat(Color.get(255, 255, 85));
        FontRenderer.COLORS[102] = Float.intBitsToFloat(Color.get(255, 255, 255));
        float factor = 0.5f;
        FontRenderer.DARK_COLORS[48] = Float.intBitsToFloat(Color.darken(Color.get(0, 0, 0), factor));
        FontRenderer.DARK_COLORS[49] = Float.intBitsToFloat(Color.darken(Color.get(0, 0, 170), factor));
        FontRenderer.DARK_COLORS[50] = Float.intBitsToFloat(Color.darken(Color.get(0, 170, 0), factor));
        FontRenderer.DARK_COLORS[51] = Float.intBitsToFloat(Color.darken(Color.get(0, 170, 170), factor));
        FontRenderer.DARK_COLORS[52] = Float.intBitsToFloat(Color.darken(Color.get(170, 0, 0), factor));
        FontRenderer.DARK_COLORS[53] = Float.intBitsToFloat(Color.darken(Color.get(170, 0, 170), factor));
        FontRenderer.DARK_COLORS[54] = Float.intBitsToFloat(Color.darken(Color.get(255, 170, 0), factor));
        FontRenderer.DARK_COLORS[55] = Float.intBitsToFloat(Color.darken(Color.get(170, 170, 170), factor));
        FontRenderer.DARK_COLORS[56] = Float.intBitsToFloat(Color.darken(Color.get(85, 85, 85), factor));
        FontRenderer.DARK_COLORS[57] = Float.intBitsToFloat(Color.darken(Color.get(85, 85, 255), factor));
        FontRenderer.DARK_COLORS[97] = Float.intBitsToFloat(Color.darken(Color.get(85, 255, 85), factor));
        FontRenderer.DARK_COLORS[98] = Float.intBitsToFloat(Color.darken(Color.get(85, 255, 255), factor));
        FontRenderer.DARK_COLORS[99] = Float.intBitsToFloat(Color.darken(Color.get(255, 85, 85), factor));
        FontRenderer.DARK_COLORS[100] = Float.intBitsToFloat(Color.darken(Color.get(255, 85, 255), factor));
        FontRenderer.DARK_COLORS[101] = Float.intBitsToFloat(Color.darken(Color.get(255, 255, 85), factor));
        FontRenderer.DARK_COLORS[102] = Float.intBitsToFloat(Color.darken(Color.get(255, 255, 255), factor));
    }
}

