/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.util;

import java.io.IOException;
import java.io.InputStream;

public class WrappedInputStream {
    private final InputStream in;

    public WrappedInputStream(InputStream in) {
        this.in = in;
    }

    private int read() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("end of stream");
        }
        return i;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public short readShort() throws IOException {
        return (short)(this.read() | this.read() << 8);
    }

    public int readInt() throws IOException {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
    }

    public long readLong() throws IOException {
        return (long)this.read() | (long)this.read() << 8 | (long)this.read() << 16 | (long)this.read() << 24 | (long)this.read() << 32 | (long)this.read() << 40 | (long)this.read() << 48 | (long)this.read() << 56;
    }

    public String readString() throws IOException {
        byte[] b = new byte[this.readInt()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)this.read();
        }
        return new String(b);
    }
}

