/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.game;

import me.hammerle.snuviengine.api.FontRenderer;
import me.hammerle.snuviengine.api.Shader;
import me.hammerle.snuviengine.game.Game;

public class Chat {
    private final char[] input = new char[256];
    private final StringBuilder[] chat = new StringBuilder[25];
    private int startIndex = 0;
    private int writeIndex = 0;
    private int viewIndex = 0;
    private int viewLenght = 5;
    private final int lineLenght = 20;

    public Chat() {
        int i;
        for (i = 0; i < this.chat.length; ++i) {
            this.chat[i] = new StringBuilder();
        }
        for (i = 0; i < 30; ++i) {
            this.addString(String.valueOf(i).toCharArray());
        }
    }

    private void nextWriteIndex() {
        int distance;
        this.writeIndex = (this.writeIndex + 1) % this.chat.length;
        this.chat[this.writeIndex].delete(0, this.chat[this.writeIndex].length());
        if (this.writeIndex == this.startIndex) {
            this.startIndex = (this.startIndex + 1) % this.chat.length;
        }
        if ((distance = this.viewIndex < this.writeIndex ? this.writeIndex - this.viewIndex : this.chat.length - this.viewIndex + this.writeIndex) - 1 == this.viewLenght) {
            this.viewIndex = (this.viewIndex + 1) % this.chat.length;
        }
    }

    private void addString(char[] text) {
        int pos = 0;
        for (int i = 0; i < text.length; ++i) {
            int j = i;
            int w = 0;
            block5: while (j < text.length) {
                switch (text[j]) {
                    case ' ': {
                        break block5;
                    }
                    case '&': {
                        if (++j >= text.length) continue block5;
                        ++j;
                        continue block5;
                    }
                    default: {
                        ++w;
                        ++j;
                        continue block5;
                    }
                }
            }
            if ((pos += w) > 20) {
                pos = w;
                this.nextWriteIndex();
            }
            while (i < j) {
                this.chat[this.writeIndex].append(text[i]);
                ++i;
            }
            ++pos;
            this.chat[this.writeIndex].append(' ');
        }
        this.nextWriteIndex();
    }

    public void tick() {
        if ((Game.DOWN.getTime() + 15 & 7) == 0 && (this.viewIndex + this.viewLenght) % this.chat.length != this.writeIndex) {
            this.viewIndex = (this.viewIndex + 1) % this.chat.length;
        }
        if ((Game.UP.getTime() + 15 & 7) == 0 && this.viewIndex != this.startIndex) {
            --this.viewIndex;
            if (this.viewIndex < 0) {
                this.viewIndex += this.chat.length;
            }
        }
    }

    public void renderTick() {
        Shader.setTextureEnabled(true);
        Shader.setColorEnabled(true);
        float x = 0.0f;
        float y = 0.0f;
        FontRenderer fr = Shader.getFontRenderer();
        int i = this.viewIndex;
        int end = (this.viewIndex + this.viewLenght) % this.chat.length;
        while (i != end) {
            y = fr.drawString(x, y, true, this.chat[i].toString());
            i = (i + 1) % this.chat.length;
        }
    }
}

