/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.io.IOException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Scanner;
import me.hammerle.snuviengine.api.ColorRenderer;
import me.hammerle.snuviengine.api.DirectTextureRenderer;
import me.hammerle.snuviengine.api.FontRenderer;
import me.hammerle.snuviengine.api.MatrixStack;
import me.hammerle.snuviengine.api.ShaderException;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL20;

public final class Renderer {
    private final int program;
    private float width;
    private float height;
    private int scale;
    private final FontRenderer fontRenderer;
    private final ColorRenderer colorRenderer = new ColorRenderer();
    private final DirectTextureRenderer textureRenderer = new DirectTextureRenderer();
    private final int unifViewMatrix;
    private final int unifModelMatrix;
    private final MatrixStack modelMatrix = new MatrixStack(20);
    private final int unifAmbientLight;
    private final int[][] unifLight = new int[32][3];
    private final int unifUseTexture;
    private final int unifUseColor;
    private final int unifUseLight;
    private final int unifUseMixColor;
    private final int unifMixColorLoc;
    private final float[] unifMixColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    protected Renderer(int width, int height) {
        this.program = this.createShaderProgram("vertex.vs", "fragment.fs");
        GL20.glUseProgram((int)this.program);
        this.unifViewMatrix = GL20.glGetUniformLocation((int)this.program, (CharSequence)"viewMatrix");
        this.fontRenderer = new FontRenderer();
        this.setViewPort(width, height);
        this.unifModelMatrix = GL20.glGetUniformLocation((int)this.program, (CharSequence)"modelMatrix");
        this.updateMatrix();
        this.unifAmbientLight = GL20.glGetUniformLocation((int)this.program, (CharSequence)"ambientLight");
        this.setAmbientLight(1.0f, 1.0f, 1.0f);
        for (int index = 0; index < this.unifLight.length; ++index) {
            this.unifLight[index][0] = GL20.glGetUniformLocation((int)this.program, (CharSequence)String.format("lights[%d].color", index));
            this.unifLight[index][1] = GL20.glGetUniformLocation((int)this.program, (CharSequence)String.format("lights[%d].pos", index));
            this.unifLight[index][2] = GL20.glGetUniformLocation((int)this.program, (CharSequence)String.format("lights[%d].strength", index));
            this.setLightColor(index, 0.0f, 0.0f, 0.0f);
            this.setLightLocation(index, 0.0f, 0.0f);
            this.setLightStrength(index, 0.0f);
        }
        this.unifUseTexture = GL20.glGetUniformLocation((int)this.program, (CharSequence)"useTexture");
        this.setTextureEnabled(false);
        this.unifUseColor = GL20.glGetUniformLocation((int)this.program, (CharSequence)"useColor");
        this.setColorEnabled(false);
        this.unifUseLight = GL20.glGetUniformLocation((int)this.program, (CharSequence)"useLight");
        this.setLightEnabled(false);
        this.unifUseMixColor = GL20.glGetUniformLocation((int)this.program, (CharSequence)"useMixColor");
        this.setMixColorEnabled(false);
        this.unifMixColorLoc = GL20.glGetUniformLocation((int)this.program, (CharSequence)"mixColor");
        this.setMixColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.setViewPort(width, height);
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public ColorRenderer getColorRenderer() {
        return this.colorRenderer;
    }

    public DirectTextureRenderer getTextureRenderer() {
        return this.textureRenderer;
    }

    private void updateViewMatrix() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        buffer.put(2.0f / this.width);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(-2.0f / this.height);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(-1.0f / this.height);
        buffer.put(0.0f);
        buffer.put(-1.0f);
        buffer.put(1.0f);
        buffer.put(0.5f);
        buffer.put(1.0f);
        buffer.flip();
        GL20.glUniformMatrix4fv((int)this.unifViewMatrix, (boolean)false, (FloatBuffer)buffer);
    }

    protected void setViewPort(float width, float height) {
        this.scale = 1;
        while (width / (float)(this.scale + 1) >= 400.0f && height / (float)(this.scale + 1) >= 300.0f) {
            ++this.scale;
        }
        this.fontRenderer.setScale(this.scale);
        this.width = width / (float)this.scale;
        this.height = height / (float)this.scale;
        this.updateViewMatrix();
    }

    public int getViewScale() {
        return this.scale;
    }

    public float getViewWidth() {
        return this.width;
    }

    public float getViewHeight() {
        return this.height;
    }

    public void updateMatrix() {
        GL20.glUniformMatrix4fv((int)this.unifModelMatrix, (boolean)false, (float[])this.modelMatrix.getData());
    }

    public void pushMatrix() {
        this.modelMatrix.push();
    }

    public void popMatrix() {
        this.modelMatrix.pop();
    }

    public void translate(float tx, float ty) {
        this.modelMatrix.translate(tx, ty);
    }

    public void translateTo(float tx, float ty) {
        this.modelMatrix.translateTo(tx, ty);
    }

    public void scale(float sx, float sy) {
        this.modelMatrix.scale(sx, sy);
    }

    public void rotate(float angle) {
        this.modelMatrix.rotate(angle);
    }

    public void setAmbientLight(float r, float g, float b) {
        GL20.glUniform3f((int)this.unifAmbientLight, (float)r, (float)g, (float)b);
    }

    private void checkLightIndex(int index) {
        if (index < 0 || index > this.unifLight.length) {
            throw new ShaderException("'%d' is not a valid light index", index);
        }
    }

    public void setLightColor(int index, float r, float g, float b) {
        this.checkLightIndex(index);
        GL20.glUniform3f((int)this.unifLight[index][0], (float)r, (float)g, (float)b);
    }

    public void setLightLocation(int index, float x, float y) {
        this.checkLightIndex(index);
        GL20.glUniform2f((int)this.unifLight[index][1], (float)x, (float)y);
    }

    public void setLightStrength(int index, float strength) {
        this.checkLightIndex(index);
        GL20.glUniform1f((int)this.unifLight[index][2], (float)strength);
    }

    public void setTextureEnabled(boolean use) {
        GL20.glUniform1i((int)this.unifUseTexture, (int)(use ? 1 : 0));
    }

    public void setColorEnabled(boolean use) {
        GL20.glUniform1i((int)this.unifUseColor, (int)(use ? 1 : 0));
    }

    public void setMixColorEnabled(boolean use) {
        GL20.glUniform1i((int)this.unifUseMixColor, (int)(use ? 1 : 0));
    }

    public void setMixColor(float r, float g, float b, float a) {
        this.unifMixColor[0] = r;
        this.unifMixColor[1] = g;
        this.unifMixColor[2] = b;
        this.unifMixColor[3] = a;
        GL20.glUniform4fv((int)this.unifMixColorLoc, (float[])this.unifMixColor);
    }

    public void setLightEnabled(boolean use) {
        GL20.glUniform1i((int)this.unifUseLight, (int)(use ? 1 : 0));
    }

    public void setDepthTestEnabled(boolean use) {
        if (use) {
            GL11.glEnable((int)2929);
            GL11.glDepthFunc((int)515);
        } else {
            GL11.glDisable((int)2929);
        }
    }

    public void setBlendingEnabled(boolean use) {
        if (use) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL14.glBlendEquation((int)32774);
        } else {
            GL11.glDisable((int)3042);
        }
    }

    private String[] readFile(String name) {
        URL url = Renderer.class.getClassLoader().getResource("me/hammerle/snuviengine/shader/" + name);
        if (url == null) {
            throw new ShaderException("failed reading shader '%s'", name);
        }
        ArrayList<String> strings = new ArrayList<String>();
        Scanner scanner = new Scanner(url.openStream());
        try {
            while (scanner.hasNext()) {
                strings.add(scanner.nextLine() + "\n");
            }
            String[] stringArray = strings.toArray(new String[strings.size()]);
            scanner.close();
            return stringArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ShaderException("failed reading shader '%s'", name);
            }
        }
    }

    private String getError() {
        StringBuilder sb = new StringBuilder();
        int glErr = GL11.glGetError();
        while (glErr != 0) {
            sb.append(glErr);
            sb.append(" ");
            glErr = GL11.glGetError();
        }
        return sb.toString();
    }

    private int createShaderProgram(String vertex, String fragment) {
        CharSequence[] vShaderSource = this.readFile(vertex);
        int vShader = GL20.glCreateShader((int)35633);
        GL20.glShaderSource((int)vShader, (CharSequence[])vShaderSource);
        GL20.glCompileShader((int)vShader);
        String error = this.getError();
        if (!error.isEmpty()) {
            throw new ShaderException("failed compiling vertex shader '%s' %s", vertex, error);
        }
        int compiled = GL20.glGetShaderi((int)vShader, (int)35713);
        if (compiled != 1) {
            throw new ShaderException("failed compiling vertex shader '%s' %d %s", vertex, compiled, GL20.glGetShaderInfoLog((int)vShader));
        }
        CharSequence[] fShaderSource = this.readFile(fragment);
        int fShader = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)fShader, (CharSequence[])fShaderSource);
        GL20.glCompileShader((int)fShader);
        error = this.getError();
        if (!error.isEmpty()) {
            throw new ShaderException("failed compiling fragment shader '%s' %s", fragment, error);
        }
        compiled = GL20.glGetShaderi((int)fShader, (int)35713);
        if (compiled != 1) {
            throw new ShaderException("failed compiling fragment shader '%s' %d %s", fragment, compiled, GL20.glGetShaderInfoLog((int)fShader));
        }
        int vfprogram = GL20.glCreateProgram();
        GL20.glAttachShader((int)vfprogram, (int)vShader);
        GL20.glAttachShader((int)vfprogram, (int)fShader);
        GL20.glLinkProgram((int)vfprogram);
        error = this.getError();
        if (!error.isEmpty()) {
            throw new ShaderException("failed linking shaders '%s' and '%s' %s", vertex, fragment, error);
        }
        compiled = GL20.glGetProgrami((int)vfprogram, (int)35714);
        if (compiled != 1) {
            throw new ShaderException("failed linking shaders '%s' and '%s' %d %s", vertex, fragment, compiled, GL20.glGetProgramInfoLog((int)vfprogram));
        }
        GL20.glDeleteShader((int)vShader);
        GL20.glDeleteShader((int)fShader);
        return vfprogram;
    }
}

