/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.util.HashMap;
import me.hammerle.snuviengine.api.KeyBinding;

public final class KeyHandler {
    private static final HashMap<Integer, KeyBinding> BINDINGS = new HashMap();
    private static KeyBinding rebind = null;

    public static KeyBinding register(int key) {
        KeyBinding binding = new KeyBinding(key);
        if (BINDINGS.putIfAbsent(key, binding) != null) {
            throw new IllegalArgumentException(String.format("the key '%s' has already been registered", key));
        }
        return binding;
    }

    public static void rebind(KeyBinding binding) {
        rebind = binding;
        if (binding != null) {
            binding.setIsRebinding(true);
        }
    }

    public static void rebind(KeyBinding binding, int key) {
        if (BINDINGS.get(binding.getKey()) == binding) {
            BINDINGS.remove(binding.getKey());
        }
        binding.setKey(key);
        BINDINGS.put(key, binding);
    }

    protected static void onKeyDownEvent(int key) {
        if (rebind != null) {
            rebind.setIsRebinding(false);
            if (!BINDINGS.containsKey(key)) {
                KeyHandler.rebind(rebind, key);
            }
            rebind = null;
            return;
        }
        KeyBinding binding = BINDINGS.get(key);
        if (binding != null) {
            binding.onKeyDownEvent();
        }
    }

    protected static void onKeyUpEvent(int key) {
        KeyBinding binding = BINDINGS.get(key);
        if (binding != null) {
            binding.onKeyUpEvent();
        }
    }

    protected static void tick() {
        BINDINGS.values().forEach(binding -> binding.tick());
    }
}

