#version 430

layout (location = 0) in vec3 pos;
layout (location = 1) in vec2 tex;
layout (location = 2) in vec4 vertexColor;

uniform sampler2D samp;

uniform mat4 viewMatrix;
uniform mat4 modelMatrix;
uniform vec3 ambientLight;

struct Light 
{
    vec2 pos;
    float strength;
    vec3 color;
}; 

uniform Light lights[32];

uniform bool useTexture;
uniform bool useColor;
uniform bool useLight;
uniform bool useMixColor;
uniform vec4 mixColor;

out vec2 tc;
out vec2 loc;
out vec4 vColor;

void main(void)
{ 
    loc = (modelMatrix * vec4(pos, 1.0)).xy;

    gl_Position = viewMatrix * modelMatrix * vec4(pos, 1.0);

    tc = tex;
    vColor = vertexColor;
}