/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class WGLNVDXInterop {
    public static final int WGL_ACCESS_READ_ONLY_NV = 0;
    public static final int WGL_ACCESS_READ_WRITE_NV = 1;
    public static final int WGL_ACCESS_WRITE_DISCARD_NV = 2;

    protected WGLNVDXInterop() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(WGLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.wglDXSetResourceShareHandleNV, caps.wglDXOpenDeviceNV, caps.wglDXCloseDeviceNV, caps.wglDXRegisterObjectNV, caps.wglDXUnregisterObjectNV, caps.wglDXObjectAccessNV, caps.wglDXLockObjectsNV, caps.wglDXUnlockObjectsNV});
    }

    @NativeType(value="BOOL")
    public static boolean wglDXSetResourceShareHandleNV(@NativeType(value="void *") long dxObject, @NativeType(value="HANDLE") long shareHandle) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXSetResourceShareHandleNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dxObject);
            Checks.check((long)shareHandle);
        }
        return JNI.callPPI((long)__functionAddress, (long)dxObject, (long)shareHandle) != 0;
    }

    @NativeType(value="HANDLE")
    public static long wglDXOpenDeviceNV(@NativeType(value="void *") long dxDevice) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXOpenDeviceNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dxDevice);
        }
        return JNI.callPP((long)__functionAddress, (long)dxDevice);
    }

    @NativeType(value="BOOL")
    public static boolean wglDXCloseDeviceNV(@NativeType(value="HANDLE") long device) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXCloseDeviceNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPI((long)__functionAddress, (long)device) != 0;
    }

    @NativeType(value="HANDLE")
    public static long wglDXRegisterObjectNV(@NativeType(value="HANDLE") long device, @NativeType(value="void *") long dxResource, @NativeType(value="GLuint") int name, @NativeType(value="GLenum") int type, @NativeType(value="GLenum") int access) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXRegisterObjectNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
            Checks.check((long)dxResource);
        }
        return JNI.callPPP((long)__functionAddress, (long)device, (long)dxResource, (int)name, (int)type, (int)access);
    }

    @NativeType(value="BOOL")
    public static boolean wglDXUnregisterObjectNV(@NativeType(value="HANDLE") long device, @NativeType(value="HANDLE") long object) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXUnregisterObjectNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
            Checks.check((long)object);
        }
        return JNI.callPPI((long)__functionAddress, (long)device, (long)object) != 0;
    }

    @NativeType(value="BOOL")
    public static boolean wglDXObjectAccessNV(@NativeType(value="HANDLE") long object, @NativeType(value="GLenum") int access) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXObjectAccessNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)object);
        }
        return JNI.callPI((long)__functionAddress, (long)object, (int)access) != 0;
    }

    public static int nwglDXLockObjectsNV(long device, int count, long objects) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXLockObjectsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPPI((long)__functionAddress, (long)device, (int)count, (long)objects);
    }

    @NativeType(value="BOOL")
    public static boolean wglDXLockObjectsNV(@NativeType(value="HANDLE") long device, @NativeType(value="HANDLE *") PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress((CustomBuffer)objects)) != 0;
    }

    public static int nwglDXUnlockObjectsNV(long device, int count, long objects) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXUnlockObjectsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPPI((long)__functionAddress, (long)device, (int)count, (long)objects);
    }

    @NativeType(value="BOOL")
    public static boolean wglDXUnlockObjectsNV(@NativeType(value="HANDLE") long device, @NativeType(value="HANDLE *") PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress((CustomBuffer)objects)) != 0;
    }
}

