/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.nio.FloatBuffer;
import me.hammerle.snuviengine.api.GLHelper;
import me.hammerle.snuviengine.api.ShaderException;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class TextureRenderer {
    private final int vao;
    private final int vbo;
    private int triangles = 0;
    private FloatBuffer buffer;
    private boolean built = false;

    public TextureRenderer(int triangles) {
        this.buffer = BufferUtils.createFloatBuffer((int)(triangles * 12));
        this.vao = GL30.glGenVertexArrays();
        this.vbo = GL15.glGenBuffers();
        GLHelper.glBindVertexArray(this.vao);
        GLHelper.glBindBuffer(this.vbo);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)16, (long)0L);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)16, (long)8L);
    }

    public void addTriangle(float x1, float y1, float x2, float y2, float x3, float y3, float tx1, float ty1, float tx2, float ty2, float tx3, float ty3) {
        if (this.buffer.position() + 12 > this.buffer.capacity()) {
            FloatBuffer newBuffer = BufferUtils.createFloatBuffer((int)(this.buffer.capacity() * 2));
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        this.buffer.put(x1);
        this.buffer.put(y1);
        this.buffer.put(tx1);
        this.buffer.put(ty1);
        this.buffer.put(x2);
        this.buffer.put(y2);
        this.buffer.put(tx2);
        this.buffer.put(ty2);
        this.buffer.put(x3);
        this.buffer.put(y3);
        this.buffer.put(tx3);
        this.buffer.put(ty3);
        ++this.triangles;
    }

    public void addRectangle(float minX, float minY, float maxX, float maxY, float tMinX, float tMinY, float tMaxX, float tMaxY) {
        this.addTriangle(minX, maxY, minX, minY, maxX, maxY, tMinX, tMaxY, tMinX, tMinY, tMaxX, tMaxY);
        this.addTriangle(maxX, maxY, minX, minY, maxX, minY, tMaxX, tMaxY, tMinX, tMinY, tMaxX, tMinY);
    }

    public boolean isBuilt() {
        return this.built;
    }

    public void build() {
        if (this.triangles == 0 || this.built) {
            return;
        }
        this.buffer.flip();
        GLHelper.glBindVertexArray(this.vao);
        GLHelper.glBindBuffer(this.vbo);
        GL15.glBufferData((int)34962, (FloatBuffer)this.buffer, (int)35044);
        this.buffer.limit(this.buffer.capacity());
        this.built = true;
    }

    public void clear() {
        this.triangles = 0;
        this.buffer.clear();
        this.built = false;
    }

    public void draw() {
        if (this.triangles == 0) {
            return;
        }
        if (!this.built) {
            throw new ShaderException("build must be called before drawing", new Object[0]);
        }
        GLHelper.glBindVertexArray(this.vao);
        GLHelper.glBindBuffer(this.vbo);
        GL11.glDrawArrays((int)4, (int)0, (int)(this.triangles * 3));
    }

    public void delete() {
        this.buffer = null;
        GL30.glDeleteVertexArrays((int)this.vao);
        GL15.glDeleteBuffers((int)this.vbo);
        this.built = false;
    }
}

