/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.regex.Pattern;
import org.lwjgl.system.Pointer;

public enum Platform {
    LINUX("Linux"){
        private final Pattern SO = Pattern.compile("(?:^|/)lib\\w+[.]so(?:[.]\\d+){0,3}$");

        @Override
        String mapLibraryName(String name) {
            if (this.SO.matcher(name).find()) {
                return name;
            }
            return System.mapLibraryName(name);
        }
    }
    ,
    MACOSX("Mac OS X"){
        private final Pattern DYLIB = Pattern.compile("(?:^|/)lib\\w+[.]dylib$");

        @Override
        String mapLibraryName(String name) {
            if (this.DYLIB.matcher(name).find()) {
                return name;
            }
            return System.mapLibraryName(name);
        }
    }
    ,
    WINDOWS("Windows"){

        @Override
        String mapLibraryName(String name) {
            if (name.endsWith(".dll")) {
                return name;
            }
            return System.mapLibraryName(name);
        }
    };

    private static final Platform PLATFORM;
    private final String name;

    private Platform(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    abstract String mapLibraryName(String var1);

    public static Platform get() {
        return PLATFORM;
    }

    public static String mapLibraryNameBundled(String name) {
        return Pointer.BITS64 ? name : name + "32";
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            PLATFORM = WINDOWS;
        } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD") || osName.startsWith("SunOS") || osName.startsWith("Unix")) {
            PLATFORM = LINUX;
        } else if (osName.startsWith("Mac OS X") || osName.startsWith("Darwin")) {
            PLATFORM = MACOSX;
        } else {
            throw new LinkageError("Unknown platform: " + osName);
        }
    }
}

