/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine;

import me.hammerle.snuviengine.api.Engine;
import me.hammerle.snuviengine.api.IGame;
import me.hammerle.snuviengine.api.Renderer;

public class Game
implements IGame {
    private float oldX = 0.0f;
    private float oldY = 0.0f;
    private float x = 0.0f;
    private float y = 0.0f;
    private float power = 10.0f;
    private final float size = 20.0f;

    @Override
    public void tick() {
        this.oldX = this.x;
        this.oldY = this.y;
        this.x += this.power;
        this.y += this.power;
        if (this.y > 300.0f || this.y < 0.0f) {
            this.power = -this.power;
        }
    }

    @Override
    public void renderTick(Renderer r, float lag) {
        r.setMixColorEnabled(false);
        r.translateTo(0.0f, 0.0f);
        r.updateMatrix();
        float ix = this.oldX + (this.x - this.oldX) * lag;
        float iy = this.oldY + (this.y - this.oldY) * lag;
        r.setTextureEnabled(false);
        r.getColorRenderer().drawRectangle(ix, iy, ix + 20.0f, iy + 20.0f, -16776961);
        float y = 200.0f;
        r.setColorEnabled(true);
        r.setTextureEnabled(true);
        y = r.getFontRenderer().drawString(30.0f, y, true, String.format("FPS: %.1f", Engine.getFramesPerSecond()));
        y = r.getFontRenderer().drawString(30.0f, y, true, String.format("Nanos Per Tick: %d", Engine.getNanosPerTick()));
        y = r.getFontRenderer().drawString(30.0f, y, true, String.format("TPS: %.1f", Engine.getTicksPerSecond()));
        y = r.getFontRenderer().drawString(30.0f, y, true, String.format("Lag: %.1f", Float.valueOf(lag)));
    }

    @Override
    public void onStop() {
    }
}

