/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import java.io.PrintStream;
import me.hammerle.snuviengine.api.IGame;
import me.hammerle.snuviengine.api.KeyHandler;
import me.hammerle.snuviengine.api.Renderer;
import me.hammerle.snuviengine.api.Timer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class Engine {
    private static long window;
    private static long nanosPerTick;
    private static final int MAX_TICKS_PER_FRAME = 20;
    private static long nanosPerFrame;
    private static Timer fpsTimer;
    private static Timer tpsTimer;
    private static Renderer renderer;

    private Engine() {
    }

    public static void start(IGame game) {
        Engine.loop(game);
        Callbacks.glfwFreeCallbacks((long)window);
        GLFW.glfwDestroyWindow((long)window);
        GLFW.glfwTerminate();
        GLFWErrorCallback error = GLFW.glfwSetErrorCallback(null);
        if (error != null) {
            error.free();
        }
    }

    public static void stop() {
        GLFW.glfwSetWindowShouldClose((long)window, (boolean)true);
    }

    public static void init(String name, int width, int height) {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)139266, (int)4);
        GLFW.glfwWindowHint((int)139267, (int)0);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        window = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)name, (long)0L, (long)0L);
        if (window == 0L) {
            throw new IllegalStateException("Failed to create the GLFW window");
        }
        GLFW.glfwSetKeyCallback((long)window, (w, key, scancode, action, mods) -> {
            if (action == 0) {
                KeyHandler.onKeyUpEvent(key);
            } else if (action == 1) {
                KeyHandler.onKeyDownEvent(key);
            }
        });
        GLFW.glfwMakeContextCurrent((long)window);
        GLFW.glfwSwapInterval((int)1);
        GL.createCapabilities();
        renderer = new Renderer(width, height);
        fpsTimer = new Timer(60.0f);
        tpsTimer = new Timer(1000000000L / nanosPerTick);
        GLFW.glfwSetFramebufferSizeCallback((long)window, (w, fwidth, fheight) -> {
            GL11.glViewport((int)0, (int)0, (int)fwidth, (int)fheight);
            renderer.setViewPort(fwidth, fheight);
        });
        GLFW.glfwShowWindow((long)window);
    }

    private static void sleep(long nanos) {
        if (nanos < 0L) {
            return;
        }
        long end = System.nanoTime() + nanos - 10000L;
        try {
            Thread.sleep(nanos / 1000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int i = 0;
        while (System.nanoTime() < end) {
            ++i;
        }
    }

    private static void loop(IGame game) {
        long newTime = System.nanoTime();
        long lag = 0L;
        long frameLag = 0L;
        long lastFrame = 0L;
        while (!GLFW.glfwWindowShouldClose((long)window)) {
            long oldTime = newTime;
            newTime = System.nanoTime();
            if ((lag += newTime - oldTime) >= nanosPerTick || (frameLag += newTime - oldTime) >= nanosPerFrame) {
                int ticksPerFrame = 0;
                while (lag >= nanosPerTick) {
                    lag -= nanosPerTick;
                    tpsTimer.update();
                    KeyHandler.tick();
                    game.tick();
                    if (++ticksPerFrame < 20) continue;
                    long skip = lag / nanosPerTick;
                    lag -= skip * nanosPerTick;
                    if (skip <= 0L) break;
                    System.out.println("skipped " + skip + " game ticks " + lag);
                    break;
                }
                if (frameLag >= nanosPerFrame) {
                    frameLag -= nanosPerFrame;
                    if (lastFrame + nanosPerFrame - 1000000L < System.nanoTime()) {
                        lastFrame = System.nanoTime();
                        game.renderTick(renderer, (float)lag / (float)nanosPerTick);
                        tpsTimer.draw(renderer);
                        fpsTimer.draw(renderer);
                        fpsTimer.update();
                        GLFW.glfwSwapBuffers((long)window);
                        GL11.glClear((int)16640);
                    }
                }
                GLFW.glfwPollEvents();
                continue;
            }
            long waitingTime = Math.min(nanosPerFrame - frameLag, nanosPerTick - lag);
            Engine.sleep(waitingTime);
        }
        game.onStop();
    }

    public static void setNanosPerTick(long nanos) {
        nanosPerTick = nanos;
        tpsTimer.setExpectedValue(1000000000L / nanos);
    }

    public static long getNanosPerTick() {
        return nanosPerTick;
    }

    public static double getTicksPerSecond() {
        return tpsTimer.getCallsPerSecond();
    }

    public static void setRenderTicksPerSecond(boolean active) {
        tpsTimer.setActive(active);
    }

    public static double getFramesPerSecond() {
        return fpsTimer.getCallsPerSecond();
    }

    public static void setMaxFramesPerSecond(int max) {
        nanosPerFrame = 1000000000 / max;
    }

    public static void setRenderFramesPerSecond(boolean active) {
        fpsTimer.setActive(active);
    }

    static {
        nanosPerTick = 10000000L;
        nanosPerFrame = 16666666L;
    }
}

