/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.Arrays;
import java.util.Iterator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class StackWalkUtil {
    private StackWalkUtil() {
    }

    static StackTraceElement[] stackWalkArray(Object[] a) {
        return (StackTraceElement[])Arrays.stream((StackWalker.StackFrame[])a).map(StackWalker.StackFrame::toStackTraceElement).toArray(StackTraceElement[]::new);
    }

    static Object stackWalkGetMethod(Class<?> after) {
        return StackWalker.getInstance().walk(s -> s.skip(2L).filter(f -> !f.getClassName().startsWith(after.getName())).findFirst()).orElseThrow(IllegalStateException::new);
    }

    private static boolean isSameMethod(StackWalker.StackFrame a, StackWalker.StackFrame b) {
        return StackWalkUtil.isSameMethod(a, b, b.getMethodName());
    }

    private static boolean isSameMethod(StackWalker.StackFrame a, StackWalker.StackFrame b, String methodName) {
        return a.getMethodName() == methodName && a.getClassName().equals(b.getClassName()) && a.getFileName().equals(b.getFileName());
    }

    private static boolean isAutoCloseable(StackWalker.StackFrame element, StackWalker.StackFrame pushed) {
        if (StackWalkUtil.isSameMethod(element, pushed, "$closeResource")) {
            return true;
        }
        return "closeFinally".equals(element.getMethodName()) && "AutoCloseable.kt".equals(element.getFileName());
    }

    static Object stackWalkCheckPop(Class<?> after, Object pushedObj) {
        return StackWalker.getInstance().walk(s -> {
            Iterator iter = s.skip(2L).dropWhile(f -> f.getClassName().startsWith(after.getName())).iterator();
            if (iter.hasNext()) {
                StackWalker.StackFrame pushed;
                StackWalker.StackFrame element = (StackWalker.StackFrame)iter.next();
                if (StackWalkUtil.isSameMethod(element, pushed = (StackWalker.StackFrame)pushedObj)) {
                    return null;
                }
                if (StackWalkUtil.isAutoCloseable(element, pushed) && iter.hasNext() && StackWalkUtil.isSameMethod(pushed, element = (StackWalker.StackFrame)iter.next())) {
                    return null;
                }
                return element;
            }
            throw new IllegalStateException();
        });
    }

    static Object[] stackWalkGetTrace() {
        return StackWalker.getInstance().walk(s -> (StackWalker.StackFrame[])s.skip(2L).dropWhile(f -> f.getClassName().startsWith("org.lwjgl.system.Memory")).toArray(StackWalker.StackFrame[]::new));
    }
}

