/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class POINT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    POINT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public POINT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), POINT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int x() {
        return POINT.nx(this.address());
    }

    @NativeType(value="LONG")
    public int y() {
        return POINT.ny(this.address());
    }

    public POINT x(@NativeType(value="LONG") int value) {
        POINT.nx(this.address(), value);
        return this;
    }

    public POINT y(@NativeType(value="LONG") int value) {
        POINT.ny(this.address(), value);
        return this;
    }

    public POINT set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public POINT set(POINT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static POINT malloc() {
        return POINT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static POINT calloc() {
        return POINT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static POINT create() {
        return new POINT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static POINT create(long address) {
        return new POINT(address, null);
    }

    @Nullable
    public static POINT createSafe(long address) {
        return address == 0L ? null : POINT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return POINT.create(POINT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return POINT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(POINT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : POINT.create(address, capacity);
    }

    public static POINT mallocStack() {
        return POINT.mallocStack(MemoryStack.stackGet());
    }

    public static POINT callocStack() {
        return POINT.callocStack(MemoryStack.stackGet());
    }

    public static POINT mallocStack(MemoryStack stack) {
        return POINT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static POINT callocStack(MemoryStack stack) {
        return POINT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return POINT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return POINT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return POINT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return POINT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = POINT.__struct(POINT.__member(4), POINT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<POINT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected POINT newInstance(long address) {
            return new POINT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="LONG")
        public int x() {
            return POINT.nx(this.address());
        }

        @NativeType(value="LONG")
        public int y() {
            return POINT.ny(this.address());
        }

        public Buffer x(@NativeType(value="LONG") int value) {
            POINT.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="LONG") int value) {
            POINT.ny(this.address(), value);
            return this;
        }
    }
}

