/*
 * Decompiled with CFR 0.152.
 */
package me.hammerle.snuviengine.api;

import org.lwjgl.glfw.GLFW;

public final class KeyBinding {
    private boolean isDown = false;
    private int time = 0;
    private boolean isReleased = false;
    private int key;
    private boolean isRebinding = false;
    private String name = null;

    protected KeyBinding(int key) {
        this.key = key;
    }

    public boolean isRebinding() {
        return this.isRebinding;
    }

    public String getName() {
        if (this.name == null) {
            switch (this.key) {
                case 265: {
                    this.name = "Up";
                    break;
                }
                case 264: {
                    this.name = "Down";
                    break;
                }
                case 263: {
                    this.name = "Left";
                    break;
                }
                case 262: {
                    this.name = "Right";
                    break;
                }
                case 340: {
                    this.name = "L-Shift";
                    break;
                }
                case 344: {
                    this.name = "R-Shift";
                    break;
                }
                case 256: {
                    this.name = "Escape";
                    break;
                }
                case 257: {
                    this.name = "Enter";
                    break;
                }
                case 32: {
                    this.name = "Space";
                    break;
                }
                default: {
                    this.name = GLFW.glfwGetKeyName((int)this.key, (int)GLFW.glfwGetKeyScancode((int)this.key));
                    if (this.name == null) break;
                    this.name = this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
                }
            }
            if (this.name == null) {
                this.name = "Unknown";
            }
        }
        return this.name;
    }

    protected void setIsRebinding(boolean b) {
        this.isRebinding = b;
    }

    protected void onKeyDownEvent() {
        this.isDown = true;
    }

    protected void onKeyUpEvent() {
        this.isReleased = true;
    }

    protected void tick() {
        if (this.isDown) {
            ++this.time;
            if (this.isReleased) {
                this.isDown = false;
            }
        } else if (this.isReleased) {
            this.isReleased = false;
            this.time = 0;
        }
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    public boolean isUp() {
        return !this.isDown;
    }

    public boolean isDown() {
        return this.isDown;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    protected void setKey(int key) {
        this.key = key;
        this.name = null;
    }

    public int getKey() {
        return this.key;
    }
}

